package itez.plat.site.controller;

import java.io.File;
import java.util.List;

import com.jfinal.upload.UploadFile;

import itez.core.runtime.auth.AuthRequire;
import itez.core.wrapper.controller.ControllerDefine;
import itez.kit.EFile;
import itez.kit.ERegex;
import itez.kit.EStr;
import itez.kit.fileup.EFileKit;
import itez.kit.fileup.FileItem;
import itez.plat.wrapper.controller.EControllerMgr;

@AuthRequire.Logined
@ControllerDefine(key = "/site/resc", summary = "网站资源", view = "/")
public class SiteRescController extends EControllerMgr {

	public void index(){
		String path = getPara("path", "");
		List<FileItem> files = EFileKit.list(getSubPath(path), true);
		setAttr("path", path);
		setAttr("files", files);
		render("resc.html");
	}
	
	public void del(){
		String path = getPara("path", "");
		String fileName = getPara("fileName");
		boolean does = EFileKit.remove(fileName);
		if(!does) setFlashMsg("删除失败：" + fileName);
		redirect(attr().getCtrl() + "?path=" + path);
	}
	
	public void folder(){
		String path = getPara("path", "");
		String folder = getPara("folder", "");
		if(EStr.isEmpty(folder)){
			setFlashMsg("目录名称不能为空！");
			redirect(attr().getCtrl() + "?path=" + path);
		}else if(!ERegex.check(folder, "[A-Za-z0-9_]+")){
			setFlashMsg("目录名称只能由字母、数字及下划线组成：" + folder);
			redirect(attr().getCtrl() + "?path=" + path);
		}
		try {
			EFileKit.createFolder(getSubPath(path + "/" + folder));
		} catch (Exception e) {
			setFlashMsg(e.getMessage() + "：" + folder);
			redirect(attr().getCtrl() + "?path=" + path);
		}
		redirect(attr().getCtrl() + "?path=" + path);
	}
	
	public void upload(){
		UploadFile fileUp = getFile("resFile");
		String path = getPara("path", "");
		if(fileUp != null) EFileKit.upload(fileUp.getFile(), getSubPath(path), false);
		redirect(attr().getCtrl() + "?path=" + path);
	}
	
	public void edit(){
		String path = getPara("path", "");
		String fileName = getPara("file", "");
		String filePath = String.format("%s/%s", path, fileName);
		filePath = getSubPath(filePath);
		File file = EFileKit.getFile(filePath);
		FileItem fileItem = new FileItem(file).loadContent();
		setAttr("path", path);
		setAttr("fileName", fileName);
		setAttr("file", fileItem);
		render("rescEdit.html");
	}
	
	public void editDo(){
		String path = getPara("path", "");
		String fileName = getPara("fileName", "");
		String content = getPara("content", "");
		String filePath = String.format("%s/%s", path, fileName);
		filePath = getSubPath(filePath);
		File file = EFileKit.getFile(filePath);
		try {
			EFile.write(file, content);
			setFlashMsg("文件修改完成：" + fileName);
		} catch (Exception e) {
			setFlashMsg("保存修改失败：" + e.getMessage());
		}
		redirect(attr().getCtrl() + "?path=" + path);
	}
	
	private String getSubPath(String path){
		if(EStr.notEmpty(path) && !path.startsWith("/")) path = "/" + path;
		return String.format("%s/res%s", attr().getDomain(), path);
	}
	
}
