package itez.plat.site.controller;

import java.util.List;

import com.google.inject.Inject;

import itez.core.runtime.auth.AuthRequire;
import itez.core.wrapper.controller.ControllerDefine;
import itez.plat.site.model.Channel;
import itez.plat.site.model.NaviItem;
import itez.plat.site.service.ChannelService;
import itez.plat.site.service.NaviItemService;
import itez.plat.wrapper.controller.EControllerMgr;

@AuthRequire.Logined
@ControllerDefine(key = "/site/naviItem", summary = "网站导航明细", view = "/")
public class SiteNaviItemController extends EControllerMgr {
	
	@Inject
	NaviItemService naviItemSer;
	
	@Inject
	ChannelService channelSer;

	public void index(String pid){
		List<NaviItem> navis = naviItemSer.getByNaviId(pid);
		Channel indexChannel = channelSer.getIndexChannel();
		List<Channel> channels = channelSer.getTreeChannels();
		setAttr("pid", pid);
		setAttr("navis", navis);
		setAttr("indexChannel", indexChannel);
		setAttr("channels", channels);
		render("naviItem.html");
	}
	
	public void addNaviItem(String pid){
		NaviItem navi = getBean(NaviItem.class, "");
		navi.setNaviId(pid);
		naviItemSer.save(navi);
		redirect(attr().getCtrl() + "?pid=" + pid);
	}
	
	public void modifyNaviItem(){
		NaviItem naviNew = getBean(NaviItem.class, "");
		NaviItem navi = naviItemSer.findById(naviNew.getId());
		String pid = navi.getNaviId();
		navi._setAttrs(naviNew);
		naviItemSer.update(navi);
		redirect(attr().getCtrl() + "?pid=" + pid);
	}
	
	public void removeNaviItem(String pid, String ids){
		naviItemSer.deleteByIds(ids);
		redirect(attr().getCtrl() + "?pid=" + pid);
	}
	
}
