package itez.plat.site.controller;

import java.util.List;

import com.google.inject.Inject;

import itez.core.runtime.auth.AuthRequire;
import itez.core.wrapper.controller.ControllerDefine;
import itez.plat.site.model.Navi;
import itez.plat.site.service.InfoService;
import itez.plat.site.service.NaviService;
import itez.plat.wrapper.controller.EControllerMgr;

@AuthRequire.Logined
@ControllerDefine(key = "/site/navi", summary = "网站导航", view = "/")
public class SiteNaviController extends EControllerMgr {

	@Inject
	InfoService infoSer;
	
	@Inject
	NaviService naviSer;

	public void index(){
		List<Navi> navis = naviSer.getNavis();
		setAttr("navis", navis);
		render("navi.html");
	}
	
	public void addNavi(){
		Navi navi = getBean(Navi.class, "");
		naviSer.save(navi);
		redirect(attr().getCtrl());
	}
	
	public void modifyNavi(){
		Navi naviNew = getBean(Navi.class, "");
		Navi navi = naviSer.findById(naviNew.getId());
		navi._setAttrs(naviNew);
		naviSer.update(navi);
		redirect(attr().getCtrl());
	}
	
	public void removeNavi(String ids){
		naviSer.deleteByIds(ids);
		redirect(attr().getCtrl());
	}
	
}
