package itez.plat.site.controller;

import com.google.inject.Inject;

import itez.core.wrapper.controller.ControllerDefine;
import itez.kit.EJson;
import itez.kit.EPara;
import itez.kit.restful.Result;
import itez.plat.main.util.ConfigKit;
import itez.plat.site.bean.SiteTempEngine;
import itez.plat.site.model.Info;
import itez.plat.site.service.InfoService;
import itez.plat.wrapper.controller.EControllerMgr;

@ControllerDefine(key = "/site/info", summary = "网站基本信息", view = "/")
public class SiteInfoController extends EControllerMgr {
	
	@Inject
	InfoService infos;

	/**
	 * 网站基本信息
	 */
	public void index(){
		Info info = infos.getInfo();
		setAttr("model", EJson.toJson(info));
		setAttr("siteStaticPage", ConfigKit.getBool("SiteStaticPage"));
		setAttr("siteStaticRoot", SiteTempEngine.getStaticRootPath());
		render("info.html");
	}
	
	/**
	 * 更新网站基本信息
	 */
	public void modify(){
		EPara paras = paramPack();
		Info exist = infos.getInfo();
		try {
			Info info = paras.getModel(Info.class);
			infos.modifyInfo(info);
			
			//如果页面模式在自动静态和手动静态间切换，需要删除已有的静态文件
			if(exist.getGenMode() > 0 && info.getGenMode() > 0 && exist.getGenMode() != info.getGenMode()){
				infos.clearStaticPages();
			}
			
			renderJson(Result.success("info", info));
		} catch (Exception e) {
			renderJson(Result.fail(e.getMessage()));
		}
	}
	
}
