package itez.plat.site.controller;

import java.util.List;

import com.google.inject.Inject;

import itez.core.runtime.auth.AuthRequire;
import itez.core.wrapper.controller.ControllerDefine;
import itez.kit.EProp;
import itez.plat.site.model.Domain;
import itez.plat.site.service.DomainService;
import itez.plat.wrapper.controller.EControllerMgr;

@AuthRequire.Logined
@ControllerDefine(key = "/site/domain", summary = "网站域名绑定", view = "/")
public class SiteDomainController extends EControllerMgr {

	@Inject
	DomainService domainSer;

	public void index(){
		List<Domain> domains = domainSer.getBinds();
		setAttr("domains", domains);
		setAttr("serverIP", EProp.ServerIP);
		render("domains.html");
	}
	
	public void add(){
		String domain = getPara("topDomain");
		domainSer.setBind(domain);
		redirect(attr().getCtrl());
	}
	
	public void remove(){
		String domain = getPara("domain");
		domainSer.removeBind(domain);
		redirect(attr().getCtrl());
	}
	
}
