package itez.plat.site.controller;

import com.google.inject.Inject;

import itez.core.wrapper.controller.ControllerDefine;
import itez.core.wrapper.controller.EController;
import itez.kit.EClean;
import itez.kit.EStr;
import itez.kit.restful.Result;
import itez.plat.site.model.Channel;
import itez.plat.site.model.Content;
import itez.plat.site.service.ChannelService;
import itez.plat.site.service.ContentService;

/**
 * <p>
 * 网站数据控制器（文章）
 * URL：/site/data/content/[Action]/[ContentID]?[PARAMS...]
 * </p>
 * 
 * <p>Copyright(C) 2017-2021 <a href="http://www.itez.com.cn">上游科技</a></p>
 * 
 * @author		<a href="mailto:netwild@qq.com">Z.Mingyu</a>
 * @date		2021年12月1日 下午4:01:59
 */
@ControllerDefine(key = "/site/data/content", summary = "网站数据控制器（文章）", view = "/")
public class SiteDataContentController extends EController {

	@Inject
	ChannelService chnSer;
	
	@Inject
	ContentService contSer;

	/**
	 * <p>
	 * 获取指定文章详情
	 * </p>
	 *
	 */
	public void by(){
		String id = EClean.clean(getPara(0), EClean.text);
		if(EStr.isEmpty(id)){
			renderJson(Result.fail("未接收到文章ID！"));
			return;
		}
		Content cont = contSer.findById(id);
		if(null == cont){
			renderJson(Result.fail("文章不存在！"));
			return;
		}
		renderJson(Result.success().setData(cont._getAttrs()));
	}

	/**
	 * <p>
	 * 获取指定文章地址
	 * </p>
	 *
	 */
	public void url(){
		String id = EClean.clean(getPara(0), EClean.text);
		if(EStr.isEmpty(id)){
			renderJson(Result.fail("未接收到文章ID！"));
			return;
		}
		Content cont = contSer.findById(id);
		if(null == cont){
			renderJson(Result.fail("文章不存在！"));
			return;
		}
		renderJson(Result.success("url", cont.url()));
	}
	
	public void next(){
		String id = EClean.clean(getPara(0), EClean.text);
		if(EStr.isEmpty(id)){
			renderJson(Result.fail("未接收到文章ID！"));
			return;
		}
		Content cont = contSer.findById(id);
		if(null == cont){
			renderJson(Result.fail("文章不存在！"));
			return;
		}
		Content next = cont.next();
		renderJson(Result.success().setData(next._getAttrs()));
	}
	
	public void previous(){
		String id = EClean.clean(getPara(0), EClean.text);
		if(EStr.isEmpty(id)){
			renderJson(Result.fail("未接收到文章ID！"));
			return;
		}
		Content cont = contSer.findById(id);
		if(null == cont){
			renderJson(Result.fail("文章不存在！"));
			return;
		}
		Content previous = cont.previous();
		renderJson(Result.success().setData(previous._getAttrs()));
	}
	
	public void channel(){
		String id = EClean.clean(getPara(0), EClean.text);
		if(EStr.isEmpty(id)){
			renderJson(Result.fail("未接收到文章ID！"));
			return;
		}
		Content cont = contSer.findById(id);
		if(null == cont){
			renderJson(Result.fail("文章不存在！"));
			return;
		}
		Channel chn = cont.channel();
		renderJson(Result.success().setData(chn._getAttrs()));
	}
	
}
