package itez.plat.site.controller;

import java.util.List;

import com.google.inject.Inject;

import itez.core.runtime.auth.AuthRequire;
import itez.core.wrapper.controller.ControllerDefine;
import itez.kit.EJson;
import itez.kit.EPara;
import itez.kit.EStr;
import itez.kit.restful.Result;
import itez.plat.main.util.ConfigKit;
import itez.plat.site.ModuleConfig;
import itez.plat.site.bean.SiteTempEngine;
import itez.plat.site.model.Channel;
import itez.plat.site.model.Info;
import itez.plat.site.model.Tags;
import itez.plat.site.service.ChannelService;
import itez.plat.site.service.InfoService;
import itez.plat.site.service.TagsService;
import itez.plat.wrapper.controller.EControllerMgr;

@AuthRequire.Logined
@ControllerDefine(key = "/site/channel", summary = "网站栏目管理", view = "/")
public class SiteChannelController extends EControllerMgr {

	@Inject
	InfoService infoSer;
	
	@Inject
	ChannelService channelSer;
	
	@Inject
	TagsService tagSer;
	
	public void index(){
		Info info = infoSer.getInfo();
		List<Tags> tags = tagSer.getTagsEnable();
		setAttr("info", EJson.toJson(info));
		setAttr("indexCode", ModuleConfig.INDEX_CODE);
		setAttr("pid", channelSer.getIndexChannel().getId());
		setAttr("staticRoot", SiteTempEngine.getStaticRootUrl());
		setAttr("tags", EJson.toJsonFilter(tags, "id", "code", "caption"));
		setAttr("SiteUpdateStop", ConfigKit.getBool("SiteUpdateStop"));
		render("channel.html");
	}
	
	public void getData(){
		List<Channel> chns = channelSer.getAllChannels();
		renderJson(Result.success("chns", chns));
	}
	
	public void singleEvent(){
		boolean SiteUpdateStop = ConfigKit.getBool("SiteUpdateStop");
		if(SiteUpdateStop){
			renderJson(Result.fail("管理员已暂停网站更新功能！"));
			return;
		}
		EPara paras = paramPack();
		Channel channel = paras.getModel(Channel.class);
		
		if(EStr.isEmpty(channel.getId())){
			channelSer.addChannel(channel);
			channelSer.arrange(null, channel.getId());
		}else{
			if(EStr.isEmpty(channel.getTagCodes())) channel.setTagCodes(null).setTagCaps(null);
			channelSer.modifyChannel(channel);
		}
		channelSer.genStaticPage(channel.getId());
		renderJson(Result.success("channel", channel));
	}
	
	public void batchEvent(){
		boolean SiteUpdateStop = ConfigKit.getBool("SiteUpdateStop");
		if(SiteUpdateStop){
			renderJson(Result.fail("管理员已暂停网站更新功能！"));
			return;
		}
		EPara paras = paramPack();
		String channelTemp = paras.getClean("channelTemp");
		String contentTemp = paras.getClean("contentTemp");
		List<Channel> chns = channelSer.findByIds(paras.get("ids"));
		chns.forEach(chn -> {
			chn.setChannelTemp(channelTemp).setContentTemp(contentTemp);
			channelSer.modifyChannel(chn);
			channelSer.genStaticPage(chn.getId());
		});
		renderJson(Result.success());
	}
	
	public void removeChannel(String pid, String ids){
		boolean SiteUpdateStop = ConfigKit.getBool("SiteUpdateStop");
		if(SiteUpdateStop){
			renderJson(Result.fail("管理员已暂停网站更新功能！"));
			return;
		}
		channelSer.removeStaticPage(ids);
		channelSer.removeChannels(ids);
		renderJson(Result.success());
	}
	
	public void sortChannel(String pid, String opt, String ids){
		boolean SiteUpdateStop = ConfigKit.getBool("SiteUpdateStop");
		if(SiteUpdateStop){
			renderJson(Result.fail("管理员已暂停网站更新功能！"));
			return;
		}
		channelSer.sort(pid, opt, ids);
		renderJson(Result.success());
	}
	
	public void move(String pid, String ids){
		List<Channel> chs = channelSer.getByIds(ids, "asc");
		chs.forEach(ch -> {
			ch.setPid(pid);
			channelSer.modifyChannel(ch);
			channelSer.arrange(null, ch.getId());
		});
		renderJson(Result.success());
	}
	
	/**
	 * <p>
	 * 删除当前静态页
	 * </p>
	 * 
	 * @param ids
	 */
	public void removeStaticPage(String ids){
		channelSer.removeStaticPage(ids);
		renderJson(Result.success());
	}
	
	/**
	 * <p>
	 * 生成静态页
	 * </p>
	 * 
	 * @param ids
	 */
	public void genStaticPage(String ids, Integer pageSize){
		try {
			channelSer.genStaticPage(ids, pageSize);
			renderJson(Result.success());
		} catch (Exception e) {
			renderJson(Result.fail(e.getMessage()));
		}
	}
	
}
