package itez.plat.site.controller;

import java.io.File;
import java.util.List;

import com.google.inject.Inject;
import com.jfinal.upload.UploadFile;

import itez.core.runtime.auth.AuthRequire;
import itez.core.wrapper.controller.ControllerDefine;
import itez.kit.EJson;
import itez.kit.restful.EMap;
import itez.kit.restful.Result;
import itez.plat.site.model.Backup;
import itez.plat.site.service.BackupService;
import itez.plat.wrapper.controller.EControllerMgr;

@AuthRequire.Logined
@ControllerDefine(key = "/site/backup", summary = "网站备份", view = "/")
public class SiteBackupController extends EControllerMgr {
	
	@Inject
	BackupService bakupSer;
	
	public void index(String type){
		List<Backup> list = bakupSer.selectAll();
		setAttr("list", EJson.toJson(list));
		render("backup.html");
	}
	
	public void create(){
		render("backupCreate.html");
	}
	
	public void createEvent(){
		EMap map = paramPack().getParas();
		String caption = map.getStr("caption");
		Backup bak = bakupSer.getByCaption(caption);
		if(bak != null){
			renderJson(Result.fail("该备份名称已存在！"));
			return;
		}
		
		bak = new Backup();
		bak.setCaption(caption);
		bak.setFileScope(map.getStr("fileScope"));
		bak.setFileScopeCaps(map.getStr("fileScopeCaps"));
		bak.setDataScope(map.getStr("dataScope"));
		bak.setDataScopeCaps(map.getStr("dataScopeCaps"));
		bak.setDataYear(map.getStr("dataYear"));
		try {
			bakupSer.create(bak);
			renderJson(Result.success());
		} catch (Exception e) {
			renderJson(Result.fail(e.getMessage()));
		}
	}
	
	public void remove(String ids){
		try {
			bakupSer.removeBak(ids);
			List<Backup> list = bakupSer.selectAll();
			renderJson(Result.success("list", list));
		} catch (Exception e) {
			renderJson(Result.fail(e.getMessage()));
		}
	}
	
	public void download(String id){
		File file = bakupSer.zip(id);
		renderFile(file);
	}
	
	public void upload(){
		render("backupLoad.html");
	}
	
	public void uploadEvent(){
		UploadFile upload = getFile("file");
		File file = upload.getFile();
		String fileName = file.getName();
		if(fileName.split("\\.")[1] != "zip"){
			setFlashMsg("备份文件格式不符合要求，请上传zip格式的压缩包文件！");
			redirect(attr().getCtrl().concat("/upload"));
		}
		try {
			bakupSer.upload(file);
			setFlashMsg("备份文件上传成功！");
			redirect(attr().getCtrl());
		} catch (Exception e) {
			setFlashMsg(e.getMessage());
			redirect(attr().getCtrl().concat("/upload"));
		}
	}
	
	public void restore(){
		EMap paras = paramPack().getParas();
		try {
			bakupSer.restore(paras);
			setFlashMsg("正在使用备份还原，可以离开当前页面，还原完成后状态将会变成“处理完毕”。");
			redirect(attr().getCtrl());
		} catch (Exception e) {
			setFlashMsg(e.getMessage());
		}
		redirect(attr().getCtrl());
	}
	
}
