package itez.plat.site.controller;

import java.util.List;

import com.beust.jcommander.internal.Lists;
import com.google.inject.Inject;
import com.jfinal.plugin.activerecord.Page;
import com.jfinal.plugin.activerecord.Record;

import itez.core.wrapper.controller.ControllerDefine;
import itez.kit.EDate;
import itez.kit.EJson;
import itez.kit.EProp;
import itez.kit.poi.XlsHeader;
import itez.kit.poi.XlsHeaderItem;
import itez.kit.poi.XlsWriter;
import itez.kit.restful.EMap;
import itez.kit.restful.Result;
import itez.plat.main.model.Comp;
import itez.plat.main.service.CompService;
import itez.plat.site.service.ContentService;
import itez.plat.wrapper.controller.EControllerMgr;

/**
 * <p>
 * 文章搜索
 * </p>
 * 
 * @author		<a href="mailto:netwild@qq.com">Z.Mingyu</a>
 * @date		2022年9月30日 上午7:44:43
 */
@ControllerDefine(key = "/site/search", summary = "网站文章搜索", view = "/")
public class SearchController extends EControllerMgr {
	
	@Inject
	CompService compSer;
	
	@Inject
	ContentService contentSer;
	
	public void index(){
		List<Comp> comps = Lists.newArrayList();
		if(session().getUser().checkSupAdmin()){
			comps = compSer.getAllComp();
		}else{
			comps.add((Comp)attr().getComp());
		}
		setAttr("domainTemp", EProp.DomainTemplate);
		setAttr("comps", EJson.toJsonFilter(comps, "domain", "caption"));
		render("search.html");
	}
	
	public void getData(){
		EMap paras = paramPack().getParas().cleanAll();
		Page<Record> list = contentSer.supSearchPage(paras, Integer.valueOf(paras.getStr("page")), 30);
		renderJson(Result.success("list", list));
	}
	
	public void exports(){
		EMap paras = paramPack().getParas().cleanAll();
		List<Record> list = contentSer.supSearch(paras);
		String fileName = "文章搜索（".concat(EDate.format(EDate.getDate(), "yyyyMMdd")).concat("）.xls");
		XlsWriter xls = XlsWriter.create(fileName);
		XlsHeader header = XlsHeader.create();
		header.addItem(new XlsHeaderItem("compCap", "站点"));
		header.addItem(new XlsHeaderItem("channelCap", "栏目"));
		header.addItem(new XlsHeaderItem("id", "文章ID"));
		header.addItem(new XlsHeaderItem("caption", "文章标题"));
		header.addItem(new XlsHeaderItem("cdate", "发布日期"));
		xls.putSheet("Sheet1", list, header);
		xls.generator();
		render(xls); //浏览器下载
	}
	
}
