package itez.plat.site.controller;

import itez.core.wrapper.controller.ControllerDefine;
import itez.kit.EStr;
import itez.plat.site.model.Channel;
import itez.plat.site.model.Content;
import itez.plat.site.model.Info;
import itez.plat.main.util.ConfigKit;
import itez.plat.site.bean.SiteTempEngine.Type;

@ControllerDefine(key = "/", summary = "主站", view = "/")
public class IndexController extends SiteController {
	
	/**
	 * <p>
	 * 首页
	 * </p>
	 *
	 */
	public void index(){
		if(!checkState()) return;
		Info site = infoSer.getInfo();
		Channel channel = channelSer.getIndexChannel();
		String view = channel.getChannelTemp();
		if(!tempSer.checkTemp(view)){
			renderEmptySite();
			return;
		}
		renderSite(Type.INDEX, site, channel, new Content(), view);
	}
	
	/**
	 * <p>
	 * 栏目页
	 * </p>
	 *
	 */
	public void channel(){
		if(!checkState()) return;
		String code = getClean(0);
		Info site = infoSer.getInfo();
		if(EStr.isEmpty(code)){
			renderText("未知栏目！");
			return;
		}
		Channel channel = channelSer.findByCode(code);
		if(null == channel){
			renderText("栏目不存在！");
			return;
		}
		String view = channel.getChannelTemp();
		if(!tempSer.checkTemp(view)){
			renderEmptySite();
			return;
		}
		renderSite(Type.CHANNEL, site, channel, new Content(), view);
	}
	
	/**
	 * <p>
	 * 内容页
	 * </p>
	 *
	 */
	public void content(){
		if(!checkState()) return;
		String id = getClean(0);
		Info site = infoSer.getInfo();
		if(EStr.isEmpty(id)){
			renderText("未知文章！");
			return;
		}
		Content content = contentSer.findById(id);
		if(null == content){
			renderText("文章不存在！");
			return;
		}
		Channel channel = channelSer.findById(content.getChannelId());
		if(null == channel){
			renderText("栏目不存在！");
			return;
		}
		String view = channel.getContentTemp();
		if(!tempSer.checkTemp(view)){
			renderEmptySite();
			return;
		}
		renderSite(Type.CONTENT, site, channel, content, view);
	}
	
	/**
	 * 网站状态检测
	 * @return
	 */
	private boolean checkState(){
		if(!ConfigKit.getBool("SiteState")){
			setAttr("msg", ConfigKit.getValue("SiteStateMsg"));
			render("site/temp/repairSite.html");
			return false;
		}
		return true;
	}
	
}
