/**
 * Copyright(C) 2021 上游科技 . All Rights Reserved
 */
package itez.plat.site.controller;

import java.util.List;

import com.google.inject.Inject;

import itez.core.wrapper.controller.ControllerDefine;
import itez.kit.EJson;
import itez.kit.EPara;
import itez.kit.restful.Result;
import itez.plat.site.model.CollectorSrc;
import itez.plat.site.service.CollectorSrcService;
import itez.plat.site.service.impl.CollectorCommon;
import itez.plat.wrapper.controller.EControllerMgr;

/**
 * <p>
 * 采集源管理
 * </p>
 * 
 * @author		<a href="mailto:netwild@qq.com">Z.Mingyu</a>
 * @date		2021年11月26日 下午10:18:19
 */
@ControllerDefine(key = "/site/collector/src", summary = "采集源管理", view = "/collector")
public class CollectorSrcController extends EControllerMgr {

	@Inject
	CollectorSrcService srcSer;
	
	public void index(){
		List<CollectorSrc> srcs = srcSer.getSrcList();
		setAttr("srcs", EJson.toJson(srcs));
		setAttr("pub_domain", CollectorCommon.PUBLIC_DOMAIN);
		render("src.html");
	}
	
	public void event(){
		EPara paras = paramPack();
		try {
			CollectorSrc src = paras.getModel(CollectorSrc.class);
			if(!paras.getBoolean("global")) src.setDomain(attr().getDomain());
			srcSer.addSrc(src);
			List<CollectorSrc> srcs = srcSer.getSrcList();
			setAttr("srcs", EJson.toJson(srcs));
			renderJson(Result.success("srcs", srcs));
		} catch (Exception e) {
			renderJson(Result.fail(e.getMessage()));
		}
	}
	
	public void remove(String id){
		srcSer.deleteById(id);
		List<CollectorSrc> srcs = srcSer.getSrcList();
		setAttr("srcs", EJson.toJson(srcs));
		renderJson(Result.success("srcs", srcs));
	}
	
}
