package itez.plat.site.controller;

import java.util.List;

import com.beust.jcommander.internal.Lists;
import com.google.inject.Inject;

import itez.core.wrapper.controller.ControllerDefine;
import itez.core.wrapper.controller.EController;
import itez.kit.EClean;
import itez.kit.EStr;
import itez.kit.restful.EMap;
import itez.kit.restful.Result;
import itez.plat.site.model.Channel;
import itez.plat.site.model.Content;
import itez.plat.site.service.ChannelService;
import itez.plat.site.service.ContentService;

/**
 * <p>
 * 微哨文章数据接口
 * </p>
 * 
 * @author		<a href="mailto:netwild@qq.com">Z.Mingyu</a>
 * @date		2022年4月19日 上午10:29:31
 */
@ControllerDefine(key = "/api/ws", summary = "微哨文章数据接口", view = "/")
public class ApiWsController extends EController {

	@Inject
	ChannelService chnSer;
	
	@Inject
	ContentService contSer;

	/**
	 * <p>
	 * 微哨门户首页卡片接口
	 * 文档：https://open.weishao.com.cn/doc/#/cardv4?id=intro
	 * 引用：//domain/api/ws/<channelCode>-[template]-[size]
	 * 
	 * 参数说明：
	 * channelCode：栏目代码
	 * template：展示方式（默认1：文字型）
	 * size：文章条数（默认10）
	 * </p>
	 *
	 */
	public void index(){
		String channelCode = EClean.clean(getPara(0), EClean.text);
		if(EStr.isEmpty(channelCode)){
			renderJson(Result.fail("未接收到栏目代码！"));
			return;
		}
		Channel chn = chnSer.findByCode(channelCode);
		if(null == chn){
			renderJson(Result.fail("栏目不存在！"));
			return;
		}
		
		EMap ret = EMap.create();
		
		/*
		 * 处理meta部分，包括：name（栏目名称）、template（展示方式）、icon（栏目图标）
		 */
		Integer template = getParaToInt(1, 1);
		EMap meta = EMap.by("name", chn.getCaption()).set("template", template);
		if(EStr.notEmpty(chn.getPic())) meta.set("icon", chn.getPic());
		ret.set("meta", meta);
		
		/*
		 * 处理global部分，包括：morelink（更多链接）
		 */
		EMap global = EMap.by("morelink", EMap.by("url", chn.domainUrl(1)));
		ret.set("global", global);
		
		/*
		 * 处理tabs部分，实现卡片标签的切换效果
		 */
		List<Channel> subs = chnSer.getChildren(chn.getId());
		Channel parentChn = chn;
		if(subs.size() > 0){ //如果存在子栏目，则返回 tabs 部分
			Integer tab = getParaToInt("tab", 0); //当切换标签时，会传入当前标签的索引，默认为第一个标签，索引0
			parentChn = subs.get(tab); //设置要获取文章的所在栏目
			List<Object> tabs = Lists.newArrayList();
			for(Channel sub : subs) tabs.add(EMap.by("name", sub.getCaption()));
			ret.set("tabs", EMap.by("data", tabs));
		}

		Integer size = getParaToInt(2, 10); //返回条数
		List<Content> conts = parentChn.list(size); //返回文章列表
		List<Object> data = Lists.newArrayList();
		for(Content cont : conts){
			EMap item = EMap.by("id", cont.getId()).set("title", cont.getCaption()).set("url", cont.domainUrl());
			item.set("text", cont.getSummary()).set("content", cont.getSummary()).set("subtitle", cont.getSummary());
			item.set("icon", cont.getThum()).set("image", cont.getThum());
			data.add(item);
		}
		ret.set("data", data);
		renderJson(ret);
	}
	
}
