package itez.plat.site.bean;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import itez.core.wrapper.render.ERender;

/**
 * <p>
 * 网站渲染类
 * </p>
 * 
 * @author		<a href="mailto:netwild@qq.com">Z.Mingyu</a>
 * @date		2021年8月19日 下午10:27:10
 */
public class SiteRender extends ERender {

	public SiteRender(String view) {
		this.view = view;
		this.contentType = "text/html";
	}
	
	/**
	 * 渲染动态页
	 */
	@Override
	public void render() {
		renderEvent(SiteTempEngine.getEngine());
	}

	/**
	 * 
	 * <p>
	 * 生成静态页
	 * </p>
	 * 
	 * @param view 模板名称
	 * @param htmlFile 生成的HTML文件
	 * @throws IOException 
	 */
	public void generator(File htmlFile) throws IOException {
		File htmlFolder = htmlFile.getParentFile();
		if(!htmlFolder.exists()) htmlFolder.mkdirs();
		if(!htmlFile.exists()) htmlFile.createNewFile();
		Map<Object, Object> data = getReqData();
		SiteTempEngine.getEngine().getTemplate(view).render(data, htmlFile);
	}

}
