package itez.plat.main.util;

import itez.core.runtime.service.Ioc;
import itez.plat.main.model.ConfigDefault;
import itez.plat.main.service.ConfigService;

public class ConfigKit {

	/**
	 * 返回当前租户的指定参数信息
	 * @param code
	 * @return
	 */
	public static ConfigDefault getConfig(String code){
		ConfigService ser = Ioc.get(ConfigService.class);
		return ser.getByCode(code);
	}
	
	/**
	 * 返回当前租户的指定参数值
	 * @param code
	 * @return
	 */
	public static String getValue(String code){
		ConfigService ser = Ioc.get(ConfigService.class);
		return ser.getValue(code);
	}
	
	/**
	 * 返回当前租户的指定参数值（布尔型）
	 * @param code
	 * @return
	 */
	public static Boolean getBool(String code){
		ConfigService ser = Ioc.get(ConfigService.class);
		return ser.getBool(code);
	}
	
	/**
	 * 返回当前租户的指定参数值（整形）
	 * @param code
	 * @return
	 */
	public static Integer getInt(String code){
		ConfigService ser = Ioc.get(ConfigService.class);
		return ser.getInt(code);
	}
	
	/**
	 * 返回当前租户的指定参数值（泛型）
	 * @param code
	 * @return
	 */
	public static <T> T getBy(String code){
		ConfigService ser = Ioc.get(ConfigService.class);
		return ser.getBy(code);
	}
	
}
