/**
 * ImportsMatch.java
 */
package itez.plat.main.service.imports;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.ArrayUtils;

import com.beust.jcommander.internal.Lists;
import com.beust.jcommander.internal.Maps;

import itez.kit.ERegex;
import itez.kit.EStr;
import itez.kit.poi.ECell;
import itez.kit.poi.ERow;

/**
 * <p>
 * 类描述
 * </p>
 * 
 * <p>Copyright(C) 2017-2020 <a href="http://www.itez.com.cn">上游科技</a></p>
 * 
 * @author		<a href="mailto:netwild@qq.com">Z.Mingyu</a>
 * @date		2020年9月16日 下午1:06:11
 */
public final class ImportsMatch {

	List<ImportsField> fields = Lists.newArrayList();
	Map<String, Integer> fieldInds = Maps.newHashMap();
		
	public ImportsMatch addField(ImportsField field){
		this.fields.add(field);
		return this;
	}
	
	/**
	 * <p>
	 * 添加普通字段（可省略该列、该列可无值）
	 * </p>
	 * 
	 * @param field
	 * @return
	 */
	public ImportsMatch addField(String field){
		this.fields.add(new ImportsField(field, false, false));
		return this;
	}
	
	/**
	 * <p>
	 * 添加必要列（不可缺少该列，但值可为空）
	 * </p>
	 * 
	 * @param field
	 * @return
	 */
	public ImportsMatch addMast(String field){
		this.fields.add(new ImportsField(field, true, false));
		return this;
	}
	
	/**
	 * <p>
	 * 添加必要列（不可缺少该列，且值不可以为空）
	 * </p>
	 * 
	 * @param field
	 * @return
	 */
	public ImportsMatch addRequire(String field){
		this.fields.add(new ImportsField(field, true, true));
		return this;
	}

	public List<ImportsField> getFields() {
		return fields;
	}

	public Map<String, Integer> getFieldInds() {
		return fieldInds;
	}
	
	/**
	 * <p>
	 * 必要列验证
	 * </p>
	 * 
	 * @param header
	 * @return
	 */
	public ImportsMatch checkMast(ERow header){
		String[] fieldNamesAll = fields.stream().map(f -> f.getField()).toArray(String[]::new);
		header.getCells().forEach(cell -> {
			Object val = cell.getValue();
			if(val != null){
				String field = val.toString();
				if(ArrayUtils.contains(fieldNamesAll, field)){
					fieldInds.put(field, cell.getCellIndex());
				}
			}
		});
		StringBuilder sb = new StringBuilder();
		fields.forEach(f -> {
			if(f.getMast() && !fieldInds.containsKey(f.getField())){
				sb.append("，").append(f.getField());
			}
		});
		if(sb.length() > 0) throw new RuntimeException("缺少必要数据列：" + sb.substring(1));
		return this;
	}
	
	/**
	 * <p>
	 * 当前行数据必要性校验
	 * </p>
	 * 
	 * @param data
	 * @return
	 */
	public Boolean checkRequire(ERow data){
		List<ECell> cells = data.getCells();
		for(ImportsField f : fields){
			if(!f.getRequired()) continue;
			Object val = cells.get(fieldInds.get(f.getField())).getValue();
			if(EStr.isEmpty(val)) return false;
		}
		return true;
	}
	
	public Integer getInd(String field){
		return fieldInds.get(field);
	}
	
	public boolean has(String field){
		return fieldInds.containsKey(field);
	}
	
	public String formatVal(Object val){
		return formatVal(val, 0);
	}
	
	public String formatVal(Object val, int scale){
		if(EStr.isEmpty(val)) return "";
		String strVal = val.toString();
		if(ERegex.check(strVal, "^[+-]?[\\d]+([\\.][\\d]+)?([Ee][+-]?[0-9]{0,2})?$")){ //整数、小数、科学计数法
			BigDecimal bd = new BigDecimal(strVal);
			return bd.setScale(scale, BigDecimal.ROUND_DOWN).toString();
		}
		return strVal.replaceAll("\\.0+$", "");
	}
	
}
