package itez.plat.main.service.impl;

import itez.core.runtime.service.EModelService;
import itez.core.runtime.service.common.IUser;
import itez.core.runtime.service.common.IUserService;
import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.kit.ECode;
import itez.kit.ELog;
import itez.kit.EProp;
import itez.kit.EStr;
import itez.kit.log.ELogBase;
import itez.kit.poi.ECell;
import itez.kit.poi.EPoi;
import itez.kit.poi.ERow;
import itez.kit.poi.ESheet;
import itez.kit.poi.Excel;
import itez.kit.poi.XlsHeader;
import itez.kit.poi.XlsHeaderItem;
import itez.kit.poi.XlsWriter;
import itez.kit.restful.EMap;
import itez.plat.main.model.Dept;
import itez.plat.main.model.Role;
import itez.plat.main.model.User;
import itez.plat.main.service.DeptService;
import itez.plat.main.service.PermService;
import itez.plat.main.service.RoleService;
import itez.plat.main.service.UserIOService;
import itez.plat.main.service.UserService;
import itez.tp.ApiCommon.USR_SOURCE;
import itez.core.runtime.cache.Cache;
import itez.core.runtime.service.Define;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.ArrayUtils;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.jfinal.kit.HashKit;
import com.jfinal.plugin.activerecord.Record;
import com.jfinal.plugin.activerecord.SqlPara;

/**
 * 由JWinner Service Generator自动生成。
 */
@Define
@Singleton
public class UserServiceImpl extends EModelService<User> implements UserService, IUserService {

	@Inject
	UserIOService uioSer;

	@Inject
	RoleService roleSer;

	@Inject
	PermService permSer;
	
	@Inject
	DeptService deptSer;
	
	private static final ELogBase log = ELog.log(UserServiceImpl.class);
	
	//用户信息可保留属性
	private static final String USER_ATTR_LIST = "id, idNum, num, type, regType, caption, deptId, deptMgrId, deptMgrCaption, loginName, level, moduleIds, roleIds, phone, email, postId, header, birthday, sex, locked, lockTime";	
	


	
	
	////////////////////////// 实现 IUserService 中的基本查找方法  //////////////////////////
	
	
	
	
	@Override
	@Cache.able(cache="USER_BY_ID", key="userId")
	public User findById(String userId) {
		return super.findById(userId);
	}

	@Override
	@Cache.able(cache="USER_BY_EMAIL", key="email")
	public User findByEmail(String email) {
		Querys qs1 = Querys.or(Query.eq("domain", $domain())).add(Query.eq("level", 2));
		Querys qs2 = Querys.and(qs1).add(Query.eq("email", email)).add(Query.eq("used", 1));
		User user = selectFirst(qs2, null, false);
		return user;
	}

	@Override
	@Cache.able(cache="USER_BY_PHONE", key="phone")
	public User findByPhone(String phone) {
		Querys qs1 = Querys.or(Query.eq("domain", $domain())).add(Query.eq("level", 2));
		Querys qs2 = Querys.and(qs1).add(Query.eq("phone", phone)).add(Query.eq("used", 1));
		User user = selectFirst(qs2, null, false);
		return user;
	}

	@Override
	@Cache.able(cache="USER_BY_IDNUM", key="idNum")
	public User findByIdNum(String idNum) {
		Querys qs1 = Querys.or(Query.eq("domain", $domain())).add(Query.eq("level", 2));
		Querys qs2 = Querys.and(qs1).add(Query.eq("idNum", idNum)).add(Query.eq("used", 1));
		User user = selectFirst(qs2, null, false);
		return user;
	}

	@Override
	@Cache.able(cache="USER_BY_NUM", key="num")
	public User findByNum(String num) {
		Querys qs1 = Querys.or(Query.eq("domain", $domain())).add(Query.eq("level", 2));
		Querys qs2 = Querys.and(qs1).add(Query.eq("num", num)).add(Query.eq("used", 1));
		User user = selectFirst(qs2, null, false);
		return user;
	}

	@Override
	@Cache.able(cache="USER_BY_LOGIN", key="loginName")
	public User findByLogin(String loginName) {
		Querys qs1 = Querys.or(Query.eq("domain", $domain())).add(Query.eq("level", 2));
		Querys qs2 = Querys.and(qs1).add(Query.eq("loginName", loginName)).add(Query.eq("used", 1));
		User user = selectFirst(qs2, null, false);
		if(null != user){
			ELog.info(">>> 根据登录账号检索到指定用户（IN DB）：domain（{}），loginName（{}），caption（{}）", $domain(), loginName, user.getCaption());
			return user;
		}else{
			ELog.error(">>> 用户登录账号不存在（IN DB）：domain（{}），loginName（{}）", $domain(), loginName);
			return null;
		}
	}

	@Override
	public User findByLogin(String loginName, String passWord) {
		User user = findByLogin(loginName);
		if(user != null){
			if(user.checkPass(passWord)) return user;
			ELog.error(">>> 用户登录密码错误：domain（{}），loginName（{}），loginPass（{}）", $domain(), loginName, passWord);
		}else{
			ELog.error(">>> 用户登录账号不存在（IN CACHE）：domain（{}），loginName（{}）", $domain(), loginName);
		}
		return null;
	}
	
	@Override
	public List<Record> findByField(String deptId, String type, Integer member, String fieldName, String keyword) {
		Integer level = 1;//$user().getLevel();
		EMap paras = EMap.by("domain", $domain()).set("level", level).set("deptId", deptId).set("type", type).set("member", member).set("fieldName", fieldName).set("keyword", keyword).set("mode", "equals");
		SqlPara sql = dbo().getSqlPara("main.FindByKeyword", paras);
		return dbo().find(sql);
	}

	
	
	
	
	////////////////////////// 实现 IUserService 中的鉴权方法  //////////////////////////
	
	
	
	

	@Override
	public boolean checkRole(IUser user, String roleCode) {
		if(user.checkAdmin()) return true;
		if(EStr.isEmpty(roleCode)) return true;
		User u = (User)user;
		String roleIds = u.getRoleIds();
		if(EStr.isEmpty(roleIds)) return false;
		String[] roles = EStr.toArray(roleIds);
		if(roles.length == 0) return false;
		return Arrays.stream(roles).anyMatch(r -> r.equals(roleCode));
	}

	@Override
	public boolean checkRoles(IUser user, String... roleCodeArr) {
		if(user.checkAdmin()) return true;
		if(roleCodeArr == null || roleCodeArr.length == 0) return true;
		User u = (User)user;
		String roleIds = u.getRoleIds();
		if(EStr.isEmpty(roleIds)) return false;
		String[] roles = EStr.toArray(roleIds);
		if(roles.length == 0) return false;
		for(String roleCode : roleCodeArr){
			if(!Arrays.stream(roles).anyMatch(r -> r.equals(roleCode))) return false;
		}
		return true;
		/*
		List<Role> roles = roleService.findByIda(EStr.toArray(roleIds));
		if(roles == null || roles.size() == 0) return false;
		Set<String> rolesHas = roles.stream().map(r -> r.getCode()).collect(Collectors.toSet());
		Set<String> rolesReq = new HashSet<String>(Arrays.asList(roleCodeArr));
		rolesHas.add($UUID()); //增加一个肯定不存在的别名，避免完全符合时Has不发生变化
		if(!rolesHas.retainAll(rolesReq)) return false;
		else return rolesReq.size() == rolesHas.size();
		*/
	}

	@Override
	public boolean checkRolesAny(IUser user, String... roleCodeArr) {
		if(user.checkAdmin()) return true;
		if(roleCodeArr == null || roleCodeArr.length == 0) return true;
		User u = (User)user;
		String roleIds = u.getRoleIds();
		if(EStr.isEmpty(roleIds)) return false;
		String[] roles = EStr.toArray(roleIds);
		if(roles.length == 0) return false;
		for(String roleCode : roleCodeArr){
			if(Arrays.stream(roles).anyMatch(r -> r.equals(roleCode))) return true;
		}
		return false;
		/*
		List<Role> roles = roleService.findByIda(EStr.toArray(roleIds));
		if(roles == null || roles.size() == 0) return false;
		Set<String> rolesHas = roles.stream().map(r -> r.getCode()).collect(Collectors.toSet());
		Set<String> rolesReq = new HashSet<String>(Arrays.asList(roleCodeArr));
		rolesHas.add($UUID()); //增加一个肯定不存在的别名，避免完全符合时Has不发生变化
		return rolesHas.retainAll(rolesReq);
		*/
	}

	@Override
	public boolean checkPerm(IUser user, String permCode) {
		if(user.checkAdmin()) return true;
		if(EStr.isEmpty(permCode)) return true;
		User u = (User)user;
		String roleIds = u.getRoleIds();
		if(EStr.isEmpty(roleIds)) return false;
		List<Role> roles = roleSer.getByCodeInComp(roleIds);
		if(roles == null || roles.size() == 0) return false;
		String[] permIds = roles.stream().map(r -> r.getPermIds().split(",")).flatMap(Arrays::stream).distinct().toArray(String[]::new);
		if(permIds == null || permIds.length == 0) return false;
		return Arrays.stream(permIds).anyMatch(p -> p.equals(permCode));
	}

	@Override
	public boolean checkPerms(IUser user, String... permCodeArr) {
		if(user.checkAdmin()) return true;
		if(permCodeArr == null || permCodeArr.length == 0) return true;
		User u = (User)user;
		String roleIds = u.getRoleIds();
		if(EStr.isEmpty(roleIds)) return false;
		List<Role> roles = roleSer.getByCodeInComp(roleIds);
		if(roles == null || roles.size() == 0) return false;
		String[] permIds = roles.stream().map(r -> r.getPermIds().split(",")).flatMap(Arrays::stream).distinct().toArray(String[]::new);
		if(permIds == null || permIds.length == 0) return false;
		for(String permCode : permCodeArr){
			if(!Arrays.stream(permIds).anyMatch(p -> p.equals(permCode))) return false;
		}
		return true;
		/*
		List<Perm> perms = permService.findByIda(permIds);
		if(perms == null || perms.size() == 0) return false;
		Set<String> permsHas = perms.stream().map(p -> p.getCode()).collect(Collectors.toSet());
		Set<String> permsReq = new HashSet<String>(Arrays.asList(permCodeArr));
		permsHas.add($UUID()); //增加一个肯定不存在的别名，避免完全符合时Has不发生变化
		if(!permsHas.retainAll(permsReq)) return false;
		else return permsReq.size() == permsHas.size();
		*/
	}

	@Override
	public boolean checkPermsAny(IUser user, String... permCodeArr) {
		if(user.checkAdmin()) return true;
		if(permCodeArr == null || permCodeArr.length == 0) return true;
		User u = (User)user;
		String roleIds = u.getRoleIds();
		if(EStr.isEmpty(roleIds)) return false;
		List<Role> roles = roleSer.getByCodeInComp(roleIds);
		if(roles == null || roles.size() == 0) return false;
		String[] permIds = roles.stream().map(r -> r.getPermIds().split(",")).flatMap(Arrays::stream).distinct().toArray(String[]::new);
		if(permIds == null || permIds.length == 0) return false;
		for(String permCode : permCodeArr){
			if(!Arrays.stream(permIds).anyMatch(p -> p.equals(permCode))) return true;
		}
		return false;
		/*
		List<Perm> perms = permService.findByIda(permIds);
		if(perms == null || perms.size() == 0) return false;
		Set<String> permsHas = perms.stream().map(p -> p.getCode()).collect(Collectors.toSet());
		Set<String> permsReq = new HashSet<String>(Arrays.asList(permCodeArr));
		permsHas.add($UUID()); //增加一个肯定不存在的别名，避免完全符合时Has不发生变化
		return permsHas.retainAll(permsReq);
		*/
	}
	
	
	
	

	
	////////////////////////// 实现 UserService 中的基本成员查找方法  //////////////////////////
	
	
	

	
	/**
	 * 返回指定部门的成员列表
	 * @param deptId
	 * @return
	 */
	@Override
	public List<User> getInsUsers(String deptId){
		return getInsUsers(deptId, null);
	}
	
	/**
	 * 返回指定部门的成员列表
	 * @param deptId
	 * @return
	 */
	@Override
	public List<User> getInsUsers(String deptId, String type){
		Querys qs = Querys.and(Query.eq("member", 1)).add(Query.le("level", $user().getLevel()));
		if(EStr.notEmpty(deptId)) qs.add(Query.eq("deptId", deptId));
		if(EStr.notEmpty(type)) qs.add(Query.in("type", EStr.ids2sqlIn(type)));
		List<User> list = select(qs, "level desc, id", null, USER_ATTR_LIST);
		return list;
	}
	
	/**
	 * 返回指定部门已离职的成员列表
	 */
	@Override
	public List<User> getLeavedUsers(String deptId) {
		Querys qs = Querys.and(Query.eq("domain", $domain())).add(Query.eq("member", 1)).add(Query.eq("used", 0)).add(Query.le("level", $user().getLevel()));
		if(deptId != null) qs.add(Query.eq("deptId", deptId));
		List<User> list = select(qs, "level desc, id", null, false, USER_ATTR_LIST);
		return list;
	}

	
	
	
	

	
	////////////////////////// 实现 UserService 中的按关键字查找成员的系列方法  //////////////////////////
	
	
	

	
	@Override
	public List<User> searchInsUser(String keyword){
		return searchInsUser(keyword, null);
	}

	@Override
	public List<User> searchInsUser(String keyword, String deptId){
		return searchInsUser(keyword, deptId, null);
	}

	@Override
	public List<User> searchInsUser(String keyword, String deptId, String type){
		Querys qs = Querys.and();
		if(EStr.notEmpty(deptId)) qs.add(Query.eq("deptId", deptId));
		if(EStr.notEmpty(type)) qs.add(Query.in("type", EStr.ids2sqlIn(type)));
		if(EStr.notEmpty(keyword)) qs.add(Querys.or(Query.like("caption", "%" + keyword + "%")).add(Query.like("idNum", "%" + keyword + "%")).add(Query.like("phone", "%" + keyword + "%")).add(Query.like("email", "%" + keyword + "%")).add(Query.like("num", "%" + keyword + "%")));
		return searchInsUser(qs);
	}

	@Override
	public List<User> searchInsUser(Querys qs) {
		Querys qs1 = Querys.and(Query.eq("member", 1)).add(Query.eq("used", 1)).add(Query.ne("level", 2));
		if(qs != null) qs1.add(qs);
		List<User> list = select(qs1, "level desc, deptId, id", null, USER_ATTR_LIST);
		return list;
	}
	
	@Override
	public List<Record> searchByField(String deptId, String type, Integer member, String fieldName, String keyword) {
		Integer level = $user().getLevel();
		EMap paras = EMap.by("domain", $domain()).set("level", level).set("deptId", deptId).set("type", type).set("member", member).set("fieldName", fieldName).set("keyword", keyword).set("mode", "like");
		SqlPara sql = dbo().getSqlPara("main.FindByKeyword", paras);
		return dbo().find(sql);
	}
	
	@Override
	public User loginByDomain(String domain, String loginName) {
		Querys qs = Querys.and(Query.eq("domain", domain)).add(Query.eq("loginName", loginName)).add(Query.eq("used", 1));
		User user = selectFirst(qs, null, false);
		return user;
	}

	
	
	
	

	
	////////////////////////// 用户管理  //////////////////////////
	
	
	

	
	
	
	/**
	 * 添加新用户
	 * @param user
	 */
	@Override
	public void add(User user, String loginPass){
		User exist;
		if(EStr.notEmpty(user.getLoginName())){
			exist = findByLogin(user.getLoginName());
			if(exist != null) throw new RuntimeException("登录名已存在！");
		}
		if(EStr.isEmpty(user.getMember())) user.setMember(0);
		if(EStr.isEmpty(user.getRegType())) user.setRegType(user.getMember() == 1 ? USR_SOURCE.MGR.name() : USR_SOURCE.REG.name());
		uioSer.addUser(user, loginPass);
		log.info("添加新成员：[id]{} [caption]{}", user.getId(), user.getCaption());
	}
	
	/**
	 * 更新用户信息
	 * @param user
	 */
	@Override
	public void modify(User user){
		uioSer.modifyUser(user);
		log.info("修改成员信息：[id]{} [caption]{}", user.getId(), user.getCaption());
	}
	
	/**
	 * 更新用户信息
	 * @param user
	 */
	@Override
	public void modify(User user, String loginPass){
		uioSer.modifyUser(user, loginPass);
	}
	
	/**
	 * 删除用户信息
	 * @param domain
	 * @param ids
	 */
	@Override
	public void remove(String ids){
		List<User> users = findByIds(ids);
		users.forEach(user -> uioSer.removeUser(user));
	}
	
	/**
	 * 恢复用户信息
	 * @param ids
	 */
	@Override
	public void reback(String ids){
		List<User> users = findByIds(ids);
		users.forEach(user -> uioSer.rebackUser(user));
	}

	/**
	 * 移动用户
	 */
	@Override
	public void move(String ids, String pidTo) {
		List<User> users = findByIds(ids);
		users.forEach(user -> uioSer.move(user, pidTo));
	}

	/**
	 * 设置管辖机构
	 */
	@Override
	public void setMgrDept(String ids, String pidTo) {
		List<User> users = findByIds(ids);
		Dept dept = deptSer.findById(pidTo);
		for(User user: users){
			user.setDeptMgrId(pidTo).setDeptMgrCaption(dept.getCaption());
			uioSer.modifyUser(user);
		}
	}

	@Override
	public String chgPassRandom(String loginName, int len) {
		User user = findByLogin(loginName);
		if(user == null) return null;
		String randPass = ECode.getRandomPass(len);
		modify(user, randPass);
		return randPass;
	}
	
	@Override
	public XlsWriter export(Dept dept) {
		return export(dept, null);
	}

	@Override
	public XlsWriter export(Dept dept, String type) {
		List<User> userModels = getInsUsers(dept.getId(), type);
		List<Record> users = parseRecords(userModels);		
		String fileName = "成员列表（".concat(dept.getCaption()).concat("）.xls");
		XlsWriter xls = XlsWriter.create(fileName);
		XlsHeader header = XlsHeader.create();
		header.addItem(new XlsHeaderItem("id", "ID"));
		header.addItem(new XlsHeaderItem("caption", "姓名"));
		header.addItem(new XlsHeaderItem("idNum", "身份证"));
		header.addItem(new XlsHeaderItem("num", "工号/学号"));
		header.addItem(new XlsHeaderItem("sex", "性别（1男0女）"));
		header.addItem(new XlsHeaderItem("phone", "手机号"));
		header.addItem(new XlsHeaderItem("email", "Email"));
		header.addItem(new XlsHeaderItem("loginName", "登录名称"));
		header.addItem(new XlsHeaderItem("loginPass", "登录密码"));
		xls.putSheet("Sheet1", users, header, false);
		xls.generator();
		return xls;
	}
	

	@Override
	public int imports(String deptId, File file){
		return importsForDept(deptId, file, null);
	}

	@Override
	public int imports(String deptId, File file, String type, boolean multiDept) {
		return multiDept ? importsMultiDept(file, type) : importsForDept(deptId, file, type);
	}
	
	/**
	 * <p>
	 * 导入到指定部门
	 * </p>
	 * 
	 * @param deptId
	 * @param file
	 * @param type
	 * @return
	 */
	private int importsForDept(String deptId, File file, String type){
		String domain = $domain();
		Excel excel = null;
		try {
			excel = EPoi.load(file);
		} catch (Exception e) {
			if(EProp.DevMode) e.printStackTrace();
			throw new RuntimeException("解析Excel文件时发送错误，请重新操作。");
		}
		ESheet sheet = excel.getSheet(0);
		int celCnt = sheet.getCellCount();
		int rowCnt = sheet.getRowCount();
		if(celCnt < 8 || rowCnt < 2) throw new RuntimeException("文件中未发现有效数据，导入失败。");
		String[] fields = { "id", "caption", "idNum", "num", "sex", "phone", "email", "loginName", "loginPass" };
		Map<String, Integer> fieldIndex = Maps.newHashMap();
		List<ERow> rows = sheet.getRows();

		//数据列对照
		ERow header = rows.get(0);
		header.getCells().forEach(cell -> {
			Object val = cell.getValue();
			if(val != null){
				String caption = val.toString();
				if(ArrayUtils.contains(fields, caption)){
					fieldIndex.put(caption, cell.getCellIndex());
				}
			}
		});
		
		//必要数据列预审
		StringBuilder sb = new StringBuilder();
		Arrays.stream(fields).forEach(f -> {
			if(!fieldIndex.containsKey(f)){
				sb.append("，").append(f);
			}
		});
		if(sb.length() > 0) throw new RuntimeException("缺少必要数据列：" + sb.substring(1));
		
		int cnt = 0;
		
		//开始执行导入
		for(ERow row : rows){
			if(row.getIndex() < 2) continue;
			List<ECell> cells = row.getCells();
			Object idObj = cells.get(fieldIndex.get("id")).getValue();
			Object captionObj = cells.get(fieldIndex.get("caption")).getValue();
			Object idNumObj = cells.get(fieldIndex.get("idNum")).getValue();
			Object numObj = cells.get(fieldIndex.get("num")).getValue();
			Object sexObj = cells.get(fieldIndex.get("sex")).getValue();
			Object phoneObj = cells.get(fieldIndex.get("phone")).getValue();
			Object emailObj = cells.get(fieldIndex.get("email")).getValue();
			Object loginNameObj = cells.get(fieldIndex.get("loginName")).getValue();
			Object loginPassObj = cells.get(fieldIndex.get("loginPass")).getValue();
			
			if(EStr.isEmpty(captionObj) || EStr.isEmpty(loginNameObj)) continue;
			
			String id = formatNum(idObj);
			String caption = formatNum(captionObj);
			String idNum = formatNum(idNumObj);
			String num = formatNum(numObj);
			String sex = formatNum(sexObj);
			String phone = formatNum(phoneObj);
			String email = formatNum(emailObj);
			String loginName = formatNum(loginNameObj);
			String loginPass = formatNum(loginPassObj);
			
			if(EStr.isEmpty(id)){
				
				User uex = findByLogin(loginName);
				if(uex != null) continue;
				if(EStr.notEmpty(idNum)){
					uex = findByIdNum(idNum);
					if(uex != null) continue;
				}
				if(EStr.notEmpty(num)){
					uex = findByNum(num);
					if(uex != null) continue;
				}
				if(EStr.notEmpty(phone)){
					uex = findByPhone(phone);
					if(uex != null) continue;
				}
				if(EStr.notEmpty(email)){
					uex = findByEmail(email);
					if(uex != null) continue;
				}
				
				User u = new User();
				u.setMember(1).setLevel(0).setDeptId(deptId).setType(type);
				u.setCaption(caption).setSex(sex).setIdNum(idNum).setNum(num).setPhone(phone).setEmail(email).setLoginName(loginName);
				add(u, EStr.ifEmpty(loginPass, loginName));
				cnt++;
			}else{
				User u = findById(id);
				if(u != null && u.getDeptId().equals(deptId)){

					User uex = findByLogin(domain, loginName);
					if(uex != null && !uex.getId().equals(id)) continue;
					if(EStr.notEmpty(idNum)){
						uex = findByIdNum(idNum);
						if(uex != null && !uex.getId().equals(id)) continue;
					}
					if(EStr.notEmpty(num)){
						uex = findByNum(num);
						if(uex != null && !uex.getId().equals(id)) continue;
					}
					if(EStr.notEmpty(phone)){
						uex = findByPhone(phone);
						if(uex != null && !uex.getId().equals(id)) continue;
					}
					if(EStr.notEmpty(email)){
						uex = findByEmail(email);
						if(uex != null && !uex.getId().equals(id)) continue;
					}
					
					if(EStr.notEmpty(caption)) u.setCaption(caption);
					if(EStr.notEmpty(sex)) u.setSex(sex);
					if(EStr.notEmpty(idNum)) u.setIdNum(idNum);
					if(EStr.notEmpty(num)) u.setNum(num);
					if(EStr.notEmpty(phone)) u.setPhone(phone);
					if(EStr.notEmpty(email)) u.setEmail(email);
					if(EStr.notEmpty(loginName)) u.setLoginName(loginName);
					if(EStr.notEmpty(loginPass)) u.setLoginPass(HashKit.md5(loginPass + u.getSalt()));
					modify(u);
					cnt++;
				}
			}
		}
		
		return cnt;
	}
	
	/**
	 * <p>
	 * 根据导入模板中的“dept”部门名称列自动导入到所属部门
	 * </p>
	 * 
	 * @param file
	 * @param type
	 * @return
	 */
	private int importsMultiDept(File file, String type){
		String domain = $domain();
		Excel excel = null;
		try {
			excel = EPoi.load(file);
		} catch (Exception e) {
			if(EProp.DevMode) e.printStackTrace();
			throw new RuntimeException("解析Excel文件时发送错误，请重新操作。");
		}
		ESheet sheet = excel.getSheet(0);
		int celCnt = sheet.getCellCount();
		int rowCnt = sheet.getRowCount();
		if(celCnt < 8 || rowCnt < 2) throw new RuntimeException("文件中未发现有效数据，导入失败。");
		String[] fields = { "dept", "caption", "role", "idNum", "phone", "sex", "email", "loginName", "loginPass" };
		Map<String, Integer> fieldIndex = Maps.newHashMap();
		List<ERow> rows = sheet.getRows();

		//数据列对照
		ERow header = rows.get(0);
		header.getCells().forEach(cell -> {
			Object val = cell.getValue();
			if(val != null){
				String caption = val.toString();
				if(ArrayUtils.contains(fields, caption)){
					fieldIndex.put(caption, cell.getCellIndex());
				}
			}
		});
		
		//必要数据列预审
		StringBuilder sb = new StringBuilder();
		Arrays.stream(fields).forEach(f -> {
			if(!fieldIndex.containsKey(f)){
				sb.append("，").append(f);
			}
		});
		if(sb.length() > 0) throw new RuntimeException("缺少必要数据列：" + sb.substring(1));
		
		Map<String, Boolean> userCaptionRepeat = Maps.newHashMap();		//姓名重复检测
		Map<String, String> deptCaptionDict = Maps.newHashMap();		//部门名称索引
		int cnt = 0;
		
		List<Dept> depts = deptSer.getDeptTree();
		depts.forEach(dept -> {
			deptCaptionDict.put(dept.getCaption(), dept.getId());
		});
		
		//开始执行导入
		for(ERow row : rows){
			if(row.getIndex() < 2) continue;
			List<ECell> cells = row.getCells();
			Object deptObj = cells.get(fieldIndex.get("dept")).getValue();
			Object captionObj = cells.get(fieldIndex.get("caption")).getValue();
			Object roleObj = cells.get(fieldIndex.get("role")).getValue();
			Object idNumObj = cells.get(fieldIndex.get("idNum")).getValue();
			Object phoneObj = cells.get(fieldIndex.get("phone")).getValue();
			Object sexObj = cells.get(fieldIndex.get("sex")).getValue();
			Object emailObj = cells.get(fieldIndex.get("email")).getValue();
			Object loginNameObj = cells.get(fieldIndex.get("loginName")).getValue();
			Object loginPassObj = cells.get(fieldIndex.get("loginPass")).getValue();
			
			if(EStr.isEmpty(deptObj) || EStr.isEmpty(captionObj) || EStr.isEmpty(loginNameObj)) continue;
			
			String dept = formatNum(deptObj);
			String caption = formatNum(captionObj);
			String roles = formatNum(roleObj);
			String idNum = formatNum(idNumObj);
			String phone = formatNum(phoneObj);
			String sex = formatNum(sexObj);
			String email = formatNum(emailObj);
			String loginName = formatNum(loginNameObj);
			String loginPass = formatNum(loginPassObj);
			
			if(userCaptionRepeat.containsKey(caption)) continue;
			
			String deptId = deptCaptionDict.get(dept);
			if(EStr.isEmpty(deptId)) continue;

			User uex = findByLogin(domain, loginName);
			if(uex != null) continue;
			if(EStr.notEmpty(idNum)){
				uex = findByIdNum(idNum);
				if(uex != null) continue;
			}
			if(EStr.notEmpty(phone)){
				uex = findByPhone(phone);
				if(uex != null) continue;
			}
			if(EStr.notEmpty(email)){
				uex = findByEmail(email);
				if(uex != null) continue;
			}
			
			User u = new User();
			u.setMember(1).setLevel(0).setRoleIds(roles).setType(type).setDeptId(deptId);
			u.setCaption(caption).setSex(sex).setIdNum(idNum).setPhone(phone).setEmail(email).setLoginName(loginName);
			add(u, EStr.ifEmpty(loginPass, loginName));
			userCaptionRepeat.put(caption, true);
			cnt++;
		}
		return cnt;
	}
	
	private String formatNum(Object val){
		String valStr = EStr.isEmpty(val) ? "" : val.toString();
		return valStr.replaceAll("\\.0$", "");
	}

	/**
	 * 返回指定用户的默认机构ID（if管理员：根机构 elseif 有管辖：管辖机构 else 本身机构）
	 */
	@Override
	public String getDeptId(User user) {
		if(user.checkAdmin()){ //如果是管理员，则默认返回当前租户的根机构（因为超管可跨租户登录，为了避免返回原租户的根机构，此处需要重新获取当前租户的根机构）
			return deptSer.getRootDept().getId();
		}else if(EStr.notEmpty(user.getDeptMgrId())){ //如果已配置管辖机构，则返回管辖机构
			return user.getDeptMgrId();
		}else if(EStr.notEmpty(user.getDeptId())){ //普通用户直接返回本身机构
			return user.getDeptId();
		}else{
			return null;
		}
	}

	/**
	 * 返回指定用户的默认机构（if管理员：根机构 elseif 有管辖：管辖机构 else 本身机构）
	 */
	@Override
	public Dept getDept(User user) {
		if(user.checkAdmin()) return deptSer.getRootDept();
		String deptId = getDeptId(user);
		if(deptId == null)  return null;
		return deptSer.findById(deptId);
	}

	
	
	
	
	
	
	
	

	
	/**
	 * 返回指定用户的机构树型
	 */
	@Override
	public List<Dept> getDeptTree(User user) {
		return deptSer.getDeptTree(user.getRootDeptId(), false);
	}
	
	/**
	 * 返回指定用户的机构树型
	 */
	@Override
	public List<Dept> getDeptTree(User user, boolean includeLogic) {
		return deptSer.getDeptTree(user.getRootDeptId(), includeLogic);
	}

}