package itez.plat.main.service.impl;

import itez.core.runtime.service.EModelService;
import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.kit.ELog;
import itez.kit.log.ELogBase;
import itez.core.runtime.EContext;
import itez.core.runtime.service.Define;
import itez.plat.main.model.User;
import itez.plat.main.model.UserOauth;
import itez.plat.main.service.UserOauthService;
import itez.plat.main.service.UserService;
import itez.tp.ApiCommon.USR_SOURCE;

import java.util.List;

import com.google.inject.Inject;
import com.google.inject.Singleton;

/**
 * 由JWinner Service Generator自动生成。
 */
@Define
@Singleton
public class UserOauthServiceImpl extends EModelService<UserOauth> implements UserOauthService {

	@Inject
	UserService userSer;
	
	private final static ELogBase log = ELog.log(UserOauthServiceImpl.class);
	
	@Override
	public boolean save(UserOauth model) {
		boolean ret = super.save(model);
		oauthBindLog(model); //统一写入日志
		return ret;
	}
	
	@Override
	public boolean saveOrUpdate(UserOauth model) {
		boolean ret = super.saveOrUpdate(model);
		oauthBindLog(model); //统一写入日志
		return ret;
	}
	
	@Override
	public boolean update(UserOauth model) {
		boolean ret = super.update(model);
		oauthBindLog(model); //统一写入日志
		return ret;
	}
	
	@Override
	public String getBindUid(USR_SOURCE type, String origId) {
		Querys qs = Querys.and(Query.eq("configType", type.name())).add(Query.eq("origId", origId));
		UserOauth oauth = selectFirst(qs, null, false);
		oauthLoginLog(oauth, type, "origId（跨域）", origId); //统一写入日志
		return null == oauth ? null : oauth.get("userId");
	}
	
	@Override
	public UserOauth getByOrigId(USR_SOURCE type, String origId) {
		Querys qs = Querys.and(Query.eq("configType", type.name())).add(Query.eq("origId", origId));
		UserOauth oauth = selectFirst(qs);
		oauthLoginLog(oauth, type, "origId", origId); //统一写入日志
		return oauth;
	}

	@Override
	public UserOauth getByOrigCode(USR_SOURCE type, String origCode) {
		Querys qs = Querys.and(Query.eq("configType", type.name())).add(Query.eq("origCode", origCode));
		UserOauth oauth = selectFirst(qs);
		oauthLoginLog(oauth, type, "origCode", origCode); //统一写入日志
		return oauth;
	}

	@Override
	public UserOauth getByOpenid(USR_SOURCE type, String openid) {
		Querys qs = Querys.and(Query.eq("configType", type.name())).add(Query.eq("openid", openid));
		UserOauth oauth = selectFirst(qs);
		oauthLoginLog(oauth, type, "openid", openid); //统一写入日志
		return oauth;
	}

	@Override
	public UserOauth getByUnionid(USR_SOURCE type, String unionid) {
		Querys qs = Querys.and(Query.eq("configType", type.name())).add(Query.eq("unionid", unionid));
		UserOauth oauth = selectFirst(qs);
		oauthLoginLog(oauth, type, "unionid", unionid); //统一写入日志
		return oauth;
	}

	@Override
	public UserOauth getByUserId(USR_SOURCE type, String userId) {
		Querys qs = Querys.and(Query.eq("userId", userId)).add(Query.eq("configType", type.name()));
		return selectFirst(qs);
	}

	@Override
	public List<UserOauth> getByUserId(String userId) {
		Querys qs = Querys.and(Query.eq("userId", userId));
		return select(qs);
	}
	
	/**
	 * 第三方账号集成写入日志
	 * @param model
	 */
	private void oauthBindLog(UserOauth model){
		User user = userSer.findById(model.getUserId());
		log.info("第三方账号集成：[domain]{} [session]{} [id]{} [uid]{} [uname]{} [type]{}", $domain(), EContext.getSession().getId(), model.getId(), user.getId(), user.getCaption(), model.getConfigType());
	}
	
	/**
	 * 第三方账号登录写入日志
	 * @param model
	 */
	private void oauthLoginLog(UserOauth model, USR_SOURCE type, String field, String val){
		if(model == null){
			log.info("第三方账号检索失败：[domain]{} [session]{} [type]{} [{}]{}", $domain(), EContext.getSession().getId(), type.name(), field, val);
		}else{
			User user = userSer.findById(model.getUserId());
			log.info("第三方账号检索成功：[domain]{} [session]{} [type]{} [{}]{} [uid]{} [uname]{}", $domain(), EContext.getSession().getId(), type.name(), field, val, user.getId(), user.getCaption());
		}
	}

}