package itez.plat.main.service.impl;

import itez.core.runtime.service.EModelService;
import itez.core.util.ECacheKit;
import itez.kit.ELog;
import itez.kit.EStr;
import itez.plat.main.model.Comp;
import itez.plat.main.model.User;
import itez.plat.main.service.CompService;
import itez.plat.main.service.LeavedService;
import itez.plat.main.service.UserIOService;
import itez.plat.main.service.UserService;
import itez.core.runtime.service.Define;

import java.util.List;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.jfinal.kit.HashKit;

/**
 * 由JWinner Service Generator自动生成。
 */
@Define
@Singleton
public class UserIOServiceImpl extends EModelService<User> implements UserIOService {
	
	@Inject
	CompService compSer;
	
	@Inject
	LeavedService leavedSer;
	
	@Inject
	UserService userSer;
	
	/**
	 * 添加新用户
	 * @param user
	 * @return
	 */
	public User addUser(User user, String loginPass){
		user.setSalt(HashKit.generateSaltForSha512());
		user.setLoginPass(HashKit.md5(loginPass + user.getSalt()));
		user.save();
		return user;
	}
	
	/**
	 * 更新用户信息
	 * @param user
	 * @return
	 */
	public User modifyUser(User user){
		removeCache(user);
		user.update();
		return user;
	}
	
	/**
	 * 更新用户信息
	 * @param user
	 * @return
	 */
	public User modifyUser(User user, String loginPass){
		if(EStr.notEmpty(loginPass)){
			String salt = user.getSalt();
			if(EStr.isEmpty(salt)) salt = userSer.findById(user.getId()).getSalt();
			String code = HashKit.md5(loginPass + salt);
			user.setLoginPass(code);
		}
		removeCache(user);
		user.update();
		return user;
	}
	
	/**
	 * 删除用户信息
	 * @param domain
	 * @param ids
	 */
	public void removeUser(User user){
		removeCache(user);
		user.disable();
		leavedSer.userLeave(user.getId());
	}
	
	/**
	 * 恢复用户信息
	 * @param domain
	 * @param ids
	 */
	public void rebackUser(User user){
		user.enable();
		leavedSer.userBack(user.getId());
	}

	/**
	 * 移动用户
	 */
	@Override
	public void move(User user, String pid) {
		removeCache(user);
		user.setDeptId(pid).update();
	}
	
	/**
	 * 移除缓存
	 * @param user
	 */
	private void removeCache(User user){
		User orig = userSer.findById(user.getId());
		if(orig.checkSupAdmin()){ //超管可跨子域登录，因此更新超管缓存时需要同时清除所有租户的缓存条目
			List<Comp> comps = compSer.getAllComp();
			comps.forEach(comp -> {
				String domain = comp.getDomain();
				ECacheKit.removeBase(ECacheKit.appendTenant(domain, "USER_BY_ID"), orig.getId());
				if(EStr.notEmpty(orig.getLoginName())) ECacheKit.removeBase(ECacheKit.appendTenant(domain, "USER_BY_LOGIN"), orig.getLoginName());
				if(EStr.notEmpty(orig.getEmail())) ECacheKit.removeBase(ECacheKit.appendTenant(domain, "USER_BY_EMAIL"), orig.getEmail());
				if(EStr.notEmpty(orig.getPhone())) ECacheKit.removeBase(ECacheKit.appendTenant(domain, "USER_BY_PHONE"), orig.getPhone());
				if(EStr.notEmpty(orig.getIdNum())) ECacheKit.removeBase(ECacheKit.appendTenant(domain, "USER_BY_IDNUM"), orig.getIdNum());
				if(EStr.notEmpty(orig.getNum())) ECacheKit.removeBase(ECacheKit.appendTenant(domain, "USER_BY_NUM"), orig.getNum());
			});
			ELog.info("清除超管用户信息缓存：{} {}", orig.getLoginName(), orig.getCaption());
		}else{ //普通用户只需要清除当前租户的缓存条目即可
			ECacheKit.remove("USER_BY_ID", orig.getId());
			if(EStr.notEmpty(orig.getLoginName())) ECacheKit.remove("USER_BY_LOGIN", orig.getLoginName());
			if(EStr.notEmpty(orig.getEmail())) ECacheKit.remove("USER_BY_EMAIL", orig.getEmail());
			if(EStr.notEmpty(orig.getPhone())) ECacheKit.remove("USER_BY_PHONE", orig.getPhone());
			if(EStr.notEmpty(orig.getIdNum())) ECacheKit.remove("USER_BY_IDNUM", orig.getIdNum());
			if(EStr.notEmpty(orig.getNum())) ECacheKit.remove("USER_BY_NUM", orig.getNum());
			ELog.info("清除用户信息缓存：{} {}", orig.getLoginName(), orig.getCaption());
		}
	}

}