package itez.plat.main.service.impl;

import itez.core.runtime.service.EModelService;
import itez.core.util.ECacheKit;
import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.core.runtime.cache.Cache;
import itez.core.runtime.service.Define;
import itez.plat.main.model.TpApi;
import itez.plat.main.service.TpApiService;
import itez.tp.ApiCommon.MODE;
import itez.tp.ApiCommon.TP;
import itez.tp.Loader;

import java.util.Arrays;
import java.util.List;

import com.google.common.collect.Lists;
import com.google.inject.Singleton;

/**
 * 由JWinner Service Generator自动生成。
 */
@Define
@Singleton
public class TpApiServiceImpl extends EModelService<TpApi> implements TpApiService {

	private static final String CACHE_NAME = "TP_API";
	private static final String CACHE_KEY_CUR = "CUR";
	private static final String CACHE_KEY_DEF = "DEF";
	
	@Override
	public List<Loader> getList() {
		TP[] tps = TP.values();
		List<Loader> list = Lists.newArrayList();
		Arrays.stream(tps).forEach(tp -> {
			Loader item = tp.getLoader();
			list.add(item);
		});
		return list;
	}

	@Override
	public TpApi getApiModel(TP tp) {
		Querys qs = Querys.and(Query.eq("code", tp.name()));
		return selectFirst(qs);
	}
	
	@Override
	public boolean save(TpApi model) {
		ECacheKit.remove(CACHE_NAME, CACHE_KEY_CUR + "_" + model.getCode());
		return super.save(model);
	}
	
	@Override
	public boolean update(TpApi model) {
		ECacheKit.remove(CACHE_NAME, CACHE_KEY_CUR + "_" + model.getCode());
		return super.update(model);
	}

	@Override
	@Cache.able(cache=CACHE_NAME, key="'" + CACHE_KEY_CUR + "_' + tp")
	public TpApi getApi(TP tp) {
		TpApi api = getApiModel(tp);
		return tp.getLoader().parseApi(api).formatData();
	}

	@Override
	@Cache.able(cache=CACHE_NAME, key="'" + CACHE_KEY_DEF + "_' + tp")
	public TpApi getDefApi(TP tp) {
		TpApi api = new TpApi().setCode(tp.name()).setCaption(tp.getCaption()).setEnable(true).setMode(MODE.share.name());
		return tp.getLoader().parseApi(api).formatData();
	}

}