package itez.plat.main.service.impl;

import itez.core.runtime.service.EModelService;
import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.kit.ECode;
import itez.kit.EHttp;
import itez.kit.EJson;
import itez.kit.ELog;
import itez.kit.EStr;
import itez.kit.log.ELogBase;
import itez.kit.restful.EMap;
import itez.kit.restful.Result;
import itez.kit.rsa.RsaKit;
import itez.core.runtime.service.Define;
import itez.plat.main.model.Terminal;
import itez.plat.main.service.TerminalService;

import java.io.File;
import java.util.List;
import java.util.Map;

import com.google.inject.Singleton;

/**
 * 由JWinner Service Generator自动生成。
 */
@Define
@Singleton
public class TerminalServiceImpl extends EModelService<Terminal> implements TerminalService {

	private static ELogBase log = ELog.log(TerminalServiceImpl.class);
	
	@Override
	public Terminal getTer() {
		return selectFirst();
	}

	@Override
	public Terminal getByDomain(String domain) {
		Querys qs = Querys.and(Query.eq("domain", domain));
		return selectFirst(qs, null, false);
	}

	@Override
	public List<Terminal> getTers(Querys qs) {
		return select(qs, null, null, false, "id", "domain", "caption", "url", "token", "supPwd", "lastDt");
	}

	@Override
	public List<Terminal> getActiveTer() {
		return select(Querys.and(Query.nn("lastDt")), null, null, false, "id", "domain", "caption", "url", "token", "supPwd", "lastDt");
	}

	@Override
	public List<Terminal> getAllTer() {
		return getTers(null);
	}

	@Override
	public String getAllTerJson() {
		List<Terminal> ters = getAllTer();
		return EJson.toJson(ters);
	}

	@Override
	public Terminal saveTer(Terminal ter) {
		saveOrUpdate(ter);
		return ter;
	}

	@SuppressWarnings("unchecked")
	@Override
	public String pushFile2Str(Terminal term, String url, Map<String, File> files, EMap params) {
		if(term == null){
			log.error("未找到终端信息");
			throw new RuntimeException("未找到终端信息");
		}
		try {
			String root = term.getUrl();
			if(!url.startsWith("/")) url = "/" + url;
			return EHttp.me.postFile(root + url, files, params);
		} catch (Exception e) {
			log.error("发送请求时发生错误：" + e.getMessage());
			return null;
		}
	}

	@Override
	public String pushFile2Str(String domain, String url, Map<String, File> files, EMap params) {
		Terminal term = getByDomain(domain);
		return pushFile2Str(term, url, files, params);
	}

	@Override
	public Result pushFile(Terminal term, String url, Map<String, File> files, EMap params) {
		String json = pushFile2Str(term, url, files, params);
		if(EStr.isEmpty(json)) return Result.fail("未接收到返回值");
		return Result.parseJson(json);
	}

	@Override
	public Result pushFile(String domain, String url, Map<String, File> files, EMap params) {
		String json = pushFile2Str(domain, url, files, params);
		if(EStr.isEmpty(json)) return Result.fail("未接收到返回值");
		return Result.parseJson(json);
	}

	@SuppressWarnings("unchecked")
	@Override
	public String pushData2Str(Terminal term, String url, EMap params) {
		if(term == null){
			log.error("未找到终端信息");
			throw new RuntimeException("未找到终端信息");
		}
		try {
			String root = term.getUrl();
			if(!url.startsWith("/")) url = "/" + url;
			return EHttp.me.postForm(root + url, params);
		} catch (Exception e) {
			log.error("发送请求时发生错误：" + e.getMessage());
			return null;
		}
	}

	@Override
	public String pushData2Str(String domain, String url, EMap params) {
		Terminal term = getByDomain(domain);
		return pushData2Str(term, url, params);
	}

	@Override
	public Result pushData(Terminal term, String url, EMap params) {
		String json = pushData2Str(term, url, params);
		if(EStr.isEmpty(json)) return Result.fail("未接收到返回值");
		return Result.parseJson(json);
	}

	@Override
	public Result pushData(String domain, String url, EMap params) {
		String json = pushData2Str(domain, url, params);
		if(EStr.isEmpty(json)) return Result.fail("未接收到返回值");
		return Result.parseJson(json);
	}

	@Override
	public EMap genSign(Terminal term, EMap params, String[] keys) {
		if(term == null){
			log.error("未找到终端信息");
			throw new RuntimeException("未找到终端信息");
		}
		if(EStr.isEmpty(term.getToken())){
			log.error("终端TOKEN为空");
			throw new RuntimeException("终端TOKEN为空");
		}
		StringBuffer sb = new StringBuffer();
		for(String key : keys){
			sb.append(params.getStr(key));
		}
		try {
			String sign = ECode.md5(sb.toString() + term.getToken());
			params.set("sign", sign);
		} catch (Exception e) {
			log.error("生成签名异常：{}", e.getMessage());
		}
		return params;
	}

	@Override
	public EMap encrypt(Terminal term, EMap params, String[] keys) {
		if(term == null){
			log.error("未找到终端信息");
			throw new RuntimeException("未找到终端信息");
		}
		if(EStr.isEmpty(term.getPriKey())){
			log.error("终端未签到，密钥不存在");
			throw new RuntimeException("终端未签到，密钥不存在");
		}
		try {
			for(String key : keys){
				String val = params.getStr(key);
				if(EStr.isEmpty(val)) continue;
				byte[] code = RsaKit.encryptByPrivateKey(val.getBytes(EStr.UTF_8), term.getPriKey());
				params.set(key, RsaKit.encryptBASE64(code));
			}
		} catch (Exception e) {
			log.error("加密异常：{}", e.getMessage());
			throw new RuntimeException(e.getMessage());
		}
		return params;
	}

	@Override
	public EMap decrypt(Terminal term, EMap params, String[] keys) {
		if(term == null){
			log.error("未找到终端信息");
			throw new RuntimeException("未找到终端信息");
		}
		if(EStr.isEmpty(term.getPriKey())){
			log.error("终端未签到，密钥不存在");
			throw new RuntimeException("终端未签到，密钥不存在");
		}
		try {
			for(String key : keys){
				String val = params.getStr(key);
				if(EStr.isEmpty(val)) continue;
				byte[] code = RsaKit.decryptByPrivateKey(val, term.getPriKey());
				params.set(key, new String(code, EStr.UTF_8));
			}
		} catch (Exception e) {
			log.error("解密异常：{}", e.getMessage());
			throw new RuntimeException(e.getMessage());
		}
		return params;
	}

	@Override
	public boolean valiSign(Terminal term, EMap params, String[] keys) {
		if(term == null){
			log.error("未找到终端信息");
			throw new RuntimeException("未找到终端信息");
		}
		if(EStr.isEmpty(term.getToken())){
			log.error("终端TOKEN为空");
			throw new RuntimeException("终端TOKEN为空");
		}
		String signRes = params.getStr("sign");
		if(EStr.isEmpty(signRes)){
			log.error("未找到签名");
			throw new RuntimeException("未找到签名");
		}
		StringBuffer sb = new StringBuffer();
		for(String key : keys){
			sb.append(params.getStr(key));
		}
		try {
			String sign = ECode.md5(sb.toString() + term.getToken());
			if(signRes.equals(sign)) return true;
		} catch (Exception e) {
			log.error("签名校验异常：{}", e.getMessage());
		}
		return false;
	}

}