package itez.plat.main.service.impl;

import itez.core.runtime.service.EModelService;
import itez.core.runtime.task.TaskKit;
import itez.kit.EDate;
import itez.core.runtime.service.Define;
import itez.plat.main.model.Task;
import itez.plat.main.service.TaskService;

import java.util.Date;
import java.util.List;
import java.util.Map;

import com.google.common.collect.Maps;
import com.google.inject.Singleton;

/**
 * 由JWinner Service Generator自动生成。
 */
@Define
@Singleton
public class TaskServiceImpl extends EModelService<Task> implements TaskService {

	private Map<String, TaskKit> taskMap = Maps.newConcurrentMap();
	
	@Override
	public Task findById(String id){
		return super.findById(id);
	}
	
	@Override
	public List<Task> selectAll(){
		return super.selectAll();
	}
	
	@Override
	public boolean save(Task t){
		t.setDaemon(1);
		t.setEnable(1);
		t.setRunCount(0).setRunCountOk(0).setRunCountFail(0);
		super.save(t);
		t.setRunNextDate(createTask(t)).update();
		return true;
	}
	
	@Override
	public boolean update(Task t){
		if(t.getEnable() == 1) taskMap.get(t.getId()).reset(t.getCron());
		return super.update(t);
	}

	@Override
	public boolean deleteById(String id){
		Task t = findById(id);
		if(t.getEnable() == 1) deleteTask(t.getId());
		return t.delete();
	}

	@Override
	public void disableTask(String id){
		Task t = findById(id);
		if(t.getEnable() == 1){
			deleteTask(t.getId());
			t.setEnable(0);
			update(t);
		}
	}

	@Override
	public void enableTask(String id){
		Task t = findById(id);
		if(t.getEnable() == 0){
			t.setRunNextDate(createTask(t));
			t.setEnable(1);
			update(t);
		}
	}

	@Override
	public void initTaskData(){
		List<Task> tasks = selectAll();
		tasks.forEach(t -> {
			if(t.getEnable() == 1){
				Date nextDate = createTask(t);
				t.setRunNextDate(nextDate).update();
			}
		});
	}

	@Override
	public void runBefore(String id, Date nextDate){
		Date date = EDate.getDate();
		Task task = findById(id);
		task.setRunNextDate(nextDate);
		task.setRunCount(task.getRunCount() + 1);
		task.setRunLastDate(date);
		if(task.getRunCount() == 1) task.setRunFirstDate(date);
		update(task);
	}

	@Override
	public void runAfter(String id, boolean status, String error){
		Task task = findById(id);
		if(status){
			task.setRunCountOk(task.getRunCountOk() + 1);
		}else{
			task.setRunCountFail(task.getRunCountFail() + 1);
		}
		task.setRunLastStatus(status ? 1 : 0);
		task.setRunLastError(error);
		if(task.getRunCount() == 1){
			task.setRunFirstStatus(status ? 1 : 0);
			task.setRunFirstError(error);
		}
		update(task);
	}
	
	private Date createTask(Task t){
		TaskKit task = new TaskKit(t);
		task.schedule();
		task.start();
		taskMap.put(t.getId(), task);
		return TaskKit.getNextDate(t.getCron());
	}
	
	private void deleteTask(String id){
		taskMap.get(id).stop();
		taskMap.remove(id);
	}

}