package itez.plat.main.service.impl;

import itez.core.runtime.service.EModelService;
import itez.core.runtime.session.ISessionDbService;
import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.core.wrapper.dbo.model.Selector;
import itez.plat.main.model.Session;
import itez.plat.main.service.SessionService;
import itez.core.runtime.cache.Cache;
import itez.core.runtime.service.Define;

import java.util.List;

import com.google.inject.Singleton;

/**
 * 由JWinner Service Generator自动生成。
 */
@Define
@Singleton
public class SessionServiceImpl extends EModelService<Session> implements SessionService, ISessionDbService {

	@Cache.able(key="id + '_' + name")
	public Session getBySessionName(String id, String name) {
		Selector selector = Selector.select().where(Querys.and(Query.eq("sid", id)).add(Query.eq("code", name)));
		return selectFirst(selector);
	}

	@Override
	public String getValueBySessionName(String id, String name) {
		Session item = getBySessionName(id, name);
		return item != null ? item.getValue() : null;
	}

	@Override
	public List<String> getSessionNames(String id) {
		List<String> codes = selectCol(Querys.and(Query.eq("sid", id)), "code");
		return codes;
	}

	@Override
	@Cache.del(key="id + '_' + name")
	public void setSession(String id, String name, String value) {
		Session item = getBySessionName(id, name);
		if(item == null){
			item = new Session();
			item.setSid(id).setCode(name).setValue(value).save();
		}else{
			item.setValue(value).update();
		}
	}

	@Override
	@Cache.del(key="id + '_' + name")
	public void removeSession(String id, String name) {
		Session item = getBySessionName(id, name);
		item.delete();
	}

	@Override
	public void invalidateSession(String id) {
	}

}