package itez.plat.main.service.impl;

import itez.core.runtime.service.EModelService;
import itez.core.util.ECacheKit;
import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.kit.EArr;
import itez.kit.EFile;
import itez.kit.EProp;
import itez.kit.EStr;
import itez.kit.EUid;
import itez.kit.poi.ECell;
import itez.kit.poi.EPoi;
import itez.kit.poi.ERow;
import itez.kit.poi.ESheet;
import itez.kit.poi.Excel;
import itez.plat.main.model.Comp;
import itez.plat.main.model.Module;
import itez.plat.main.model.Role;
import itez.plat.main.service.ModuleService;
import itez.plat.main.service.RoleService;
import itez.plat.main.service.imports.ImportsMatch;
import itez.core.runtime.cache.Cache;
import itez.core.runtime.modules.ModuleBase;
import itez.core.runtime.modules.ModuleManager;
import itez.core.runtime.service.Define;

import java.io.File;
import java.sql.SQLException;
import java.util.List;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.beust.jcommander.internal.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.jfinal.plugin.activerecord.IAtom;
import com.jfinal.plugin.activerecord.Record;

/**
 * 由JWinner Service Generator自动生成。
 */
@Define
@Singleton
public class RoleServiceImpl extends EModelService<Role> implements RoleService {

	@Inject
	ModuleService moduleSer;
	
	@Override
	@Cache.able(cache="ROLE_BY_ID", key="id")
	public Role findById(String id) {
		return super.findById(id);
	}

	@Override
	@Cache.able(cache="ROLE_BYIDS", key="EStr.parseArray(ids)")
	public List<Role> findByIda(String...ids){
		return super.findByIda(ids);
	}

	@Override
	@Cache.able(cache="ROLE_BY_CODES", key="codes")
	public List<Role> findByCodes(String codes){
		return super.findByCodes(codes);
	}

	@Override
	public List<Role> getByModule(String moduleCode) {
		Querys qs = Querys.and(Query.eq("moduleId", moduleCode));
		return select(qs);
	}

	@Override
	@Cache.able(cache="ROLE_ALL", key="'ALL'")
	public List<Role> getAll() {
		return selectAll();
	}

	@Override
	@Cache.able(cache="ROLE_ALL", key="'COMP'")
	public List<Role> getByComp() {
		Comp comp = (Comp)$comp();
		String moduleCodes = comp.getModules();
		Querys qs = Querys.and(Query.in("moduleId", EStr.ids2sqlIn(moduleCodes)));
		List<Role> roles = select(qs, "moduleId, sort");
		List<Module> modules = moduleSer.getByComp();
		roles = join(roles, "moduleId", modules, "code", "caption > moduleCaption");
		return roles;
	}
	
	@Override
	@Cache.able(cache="ROLE_BY_CODES", key="codes")
	public List<Role> getByCodeInComp(String codes) {
		Comp comp = (Comp)$comp();
		String moduleCodes = comp.getModules();
		Querys qs = Querys.and(Query.in("moduleId", EStr.ids2sqlIn(moduleCodes))).add(Query.in("code", EStr.ids2sqlIn(codes)));
		List<Role> roles = select(qs, "moduleId, sort");
		List<Module> modules = moduleSer.getByComp();
		roles = join(roles, "moduleId", modules, "code", "caption > moduleCaption");
		return roles;
	}
	
	@Override
	public List<Record> getByCodeInModule(String moduleIds, String codes) {
		Querys qs = Querys.and(Query.in("moduleId", EStr.ids2sqlIn(moduleIds))).add(Query.in("code", EStr.ids2sqlIn(codes)));
		List<Role> roles = select(qs, "moduleId, sort");
		List<Module> modules = moduleSer.findByCodes(moduleIds);
		roles = join(roles, "moduleId", modules, "code", "caption > moduleCaption");
		return parseRecords(roles);
	}
	
	@Override
	@Cache.delAll(cache="ROLE_ALL")
	@Cache.delAll(cache="ROLE_BYIDS")
	public boolean save(Role model) {
		return super.save(model);
	}
	
	@Override
	@Cache.del(cache="ROLE_BY_ID", key="model.id")
	@Cache.delAll(cache="ROLE_BY_CODES")
	@Cache.delAll(cache="ROLE_ALL")
	@Cache.delAll(cache="ROLE_BYIDS")
	public boolean update(Role model) {
		return super.update(model);
	}
	
	@Override
	@Cache.del(cache="ROLE_BY_ID", key="idValue")
	@Cache.delAll(cache="ROLE_BY_CODES")
	@Cache.delAll(cache="ROLE_ALL")
	@Cache.delAll(cache="ROLE_BYIDS")
	public boolean deleteById(String idValue) {
		return super.deleteById(idValue);
	}

	@Override
	@Cache.delAll(cache="ROLE_BY_ID")
	@Cache.delAll(cache="ROLE_BY_CODES")
	@Cache.delAll(cache="ROLE_ALL")
	@Cache.delAll(cache="ROLE_BYIDS")
	public int imports(String moduleCode, File file, boolean repeatCode) {
		String domain = $domain();
		Excel excel = null;
		try {
			excel = EPoi.load(file);
		} catch (Exception e) {
			if(EProp.DevMode) e.printStackTrace();
			throw new RuntimeException("解析Excel文件时发送错误，请重新操作。");
		}
		ESheet sheet = excel.getSheet(0);
		int celCnt = sheet.getCellCount();
		int rowCnt = sheet.getRowCount();
		if(celCnt < 2 || rowCnt < 2) throw new RuntimeException("文件中未发现有效数据，导入失败。");
		
		ImportsMatch match = new ImportsMatch();
		match.addRequire("code").addRequire("caption").addField("summary").addField("permIds");
		List<ERow> rows = sheet.getRows();
		match.checkMast(rows.get(0));

		List<Role> roleSave = Lists.newArrayList();
		List<Role> roleUpdate = Lists.newArrayList();

		Integer sort = 0;
		List<Role> exists = getByModule(moduleCode);
		if(exists.size() > 0) sort = exists.get(exists.size() - 1).getSort();

		//开始执行导入
		for(ERow row : rows){
			if(row.getIndex() < 2) continue;
			List<ECell> cells = row.getCells();
			if(!match.checkRequire(row)) continue;
			Object codeObj = cells.get(match.getInd("code")).getValue();
			Object captionObj = cells.get(match.getInd("caption")).getValue();
			Object summaryObj = cells.get(match.getInd("summary")).getValue();
			Object permIdsObj = cells.get(match.getInd("permIds")).getValue();
			String code = formatNum(codeObj);
			String caption = formatNum(captionObj);
			String summary = formatNum(summaryObj);
			String permIds = formatNum(permIdsObj);

			Role exist = exists.stream().filter(r -> r.getCode().equals(code)).findFirst().orElse(null);
			if(exist != null && !repeatCode) continue; //跳过已存在的

			if(exist == null){ //新增加
				Role role = new Role();
				role.setId(EUid.generator()).setDomain(domain).setModuleId(moduleCode).setUsed(1);
				role.setCode(code).setCaption(caption).setSummary(summary).setPermIds(permIds);
				role.setSort(sort + row.getIndex());
				roleSave.add(role);
			}else{ //覆盖原来的
				exist.setCaption(caption).setSummary(summary).setPermIds(permIds);
				exist.setSort(sort + row.getIndex());
				roleUpdate.add(exist);
			}
		}
		if(roleSave.size() == 0 && roleUpdate.size() == 0) return 0;
		boolean state = dbo().tx(new IAtom(){
			@Override
			public boolean run() throws SQLException {
				int[] ret1 = dbo().batchSave(roleSave, roleSave.size());
				int[] ret2 = dbo().batchUpdate(roleUpdate, roleUpdate.size());
				return EArr.valiAny(ret1, ret2);
			}
		});
		return state ? roleSave.size() : 0;
	}
	
	private String formatNum(Object val){
		String valStr = EStr.isEmpty(val) ? "" : val.toString();
		return valStr.replaceAll("\\.0$", "");
	}
	
	@Override
	public Role findInCompByCode(String domain, String code) {
		Querys qs = Querys.and(Query.eq("domain", domain)).add(Query.eq("code", code));
		return selectFirst(qs, null, false);
	}

	@Override
	public void importJson(String domain, String moduleCode) {
		if(EStr.isEmpty(domain)) domain = $domain();
		
		ModuleBase module = ModuleManager.me.getModule(moduleCode);
		if(module == null) throw new RuntimeException("模块不存在！");
		
		String moduleView = module.getModuleView();
		String jsonFile = moduleView + "/init/role.json";
		String jsonData = EFile.readInRes(jsonFile);
		if(jsonData == null) return;
		importJson(domain, moduleCode, jsonData);
		
		ECacheKit.removeAllBase(ECacheKit.appendTenant(domain, "ROLE_ALL"));
		ECacheKit.removeAllBase(ECacheKit.appendTenant(domain, "ROLE_BY_CODES"));
	}

	@Override
	public void importJson(String domain, String moduleCode, String json) {
		List<Role> adds = Lists.newArrayList();
		JSONArray arrs = JSON.parseArray(json);
		for(int i = 0, l = arrs.size(); i < l; i++){
			Role role = arrs.getObject(i, Role.class);
			if(findInCompByCode(domain, role.getCode()) != null) continue;
			role.setId(EUid.generator()).setDomain(domain).setModuleId(moduleCode).setUsed(1);
			adds.add(role);
		}
		if(adds.size() == 0) return;
		dbo().tx(new IAtom(){
			@Override
			public boolean run() throws SQLException {
				int[] b1 = dbo().batchSave(adds, adds.size());
				return EArr.vali(b1);
			}
		});
	}

}