package itez.plat.main.service.impl;

import itez.core.runtime.service.EModelService;
import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.plat.main.model.Post;
import itez.plat.main.service.PostService;
import itez.core.runtime.cache.Cache;
import itez.core.runtime.service.Define;

import com.google.inject.Singleton;

/**
 * 由JWinner Service Generator自动生成。
 */
@Define
@Singleton
public class PostServiceImpl extends EModelService<Post> implements PostService {

	@Override
	@Cache.able(cache="POST_BY_ID", key="id")
	public Post findById(String id) {
		return super.findById(id);
	}
	
	/**
	 * 返回tmid对应的机构
	 * @param tmid
	 * @return
	 */
	public Post findByTmid(Object tmid) {
		Querys qs = Querys.and(Query.eq("tmid", tmid));
		return selectFirst(qs);
	}

	public void addPost(Post post){
		post.save();
	}

}