package itez.plat.main.service.impl;

import java.util.List;

import com.beust.jcommander.internal.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.jfinal.plugin.activerecord.Model;
import com.jfinal.plugin.activerecord.Record;

import itez.core.runtime.service.Define;
import itez.core.runtime.service.EService;
import itez.kit.EPara;
import itez.kit.restful.EMap;
import itez.plat.main.model.PolicyLock;
import itez.plat.main.model.PolicyPwd;
import itez.plat.main.service.PolicyLockService;
import itez.plat.main.service.PolicyPwdService;
import itez.plat.main.service.PolicyService;

@Define
@Singleton
@SuppressWarnings("rawtypes")
public class PolicyServiceImpl extends EService implements PolicyService {

	@Inject
	PolicyPwdService pwdSer;

	@Inject
	PolicyLockService lockSer;
	
	public enum POLICYS {
		PWD("密码安全策略"), LOCK("登录锁定策略");
		private String caption;
		POLICYS(String caption){
			this.caption = caption;
		}
		public String getCaption(){
			return this.caption;
		}
	}

	@Override
	public List<EMap> getPolicyList() {
		List<EMap> list = Lists.newArrayList();
		list.add(EMap.by("code", POLICYS.PWD.name()).set("caption", POLICYS.PWD.caption));
		list.add(EMap.by("code", POLICYS.LOCK.name()).set("caption", POLICYS.LOCK.caption));
		return list;
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<Record> getDetails(POLICYS type) {
		List<? extends Model> list;
		if(type == POLICYS.PWD) list = pwdSer.selectAll();
		else list = lockSer.selectAll();
		return parseRecords(list);
	}

	@Override
	public void modify(POLICYS type, EPara paras) {
		if(type == POLICYS.PWD){
			PolicyPwd model = paras.getModel(PolicyPwd.class);
			pwdSer.saveOrUpdate(model);
		}else{
			PolicyLock model = paras.getModel(PolicyLock.class);
			lockSer.saveOrUpdate(model);
		}
	}

	@Override
	public void remove(POLICYS type, String code) {
		if(type == POLICYS.PWD) pwdSer.deleteByCodes(code);
		else lockSer.deleteByCodes(code);
	}
	
}
