package itez.plat.main.service.impl;

import itez.core.runtime.service.EModelService;
import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.kit.EStr;
import itez.core.runtime.cache.Cache;
import itez.core.runtime.service.Define;
import itez.plat.main.model.PolicyPwd;
import itez.plat.main.service.PolicyPwdService;

import java.util.List;

import com.google.inject.Singleton;

/**
 * 由JWinner Service Generator自动生成。
 */
@Define
@Singleton
public class PolicyPwdServiceImpl extends EModelService<PolicyPwd> implements PolicyPwdService {
	
	private final static String DEF_CODE = "_DEF_";
	
	@Override
	public List<PolicyPwd> selectAll() {
		List<PolicyPwd> list = super.selectAllBy("def desc");
		if(list.size() == 0) list.add(initDef());
		return list;
	}

	@Override
	@Cache.able(cache="Policy_Pwd_Code", key="'" + DEF_CODE + "'")
	public PolicyPwd getPolicy() {
		Querys qs = Querys.and(Query.eq("def", true));
		PolicyPwd policy = selectFirst(qs);
		if(policy == null) policy = initDef();
		return policy;
	}

	@Override
	@Cache.able(cache="Policy_Pwd_Code", key="code")
	public PolicyPwd getPolicy(String code) {
		PolicyPwd policy = null;
		if(EStr.notEmpty(code)) policy = findByCode(code);
		if(EStr.isNull(policy)) policy = getPolicy();
		return policy;
	}
	
	@Override
	@Cache.delAll(cache="Policy_Pwd_Code")
	public boolean saveOrUpdate(PolicyPwd model) {
		if(EStr.isEmpty(model.getId())){
			PolicyPwd exist = findByCode(model.getCode());
			if(null != exist) throw new RuntimeException("策略代码已存在！");
		}
		return super.saveOrUpdate(model);
	}
	
	@Override
	@Cache.del(cache="Policy_Pwd_Code", key="codes")
	public boolean deleteByCodes(String codes) {
		return super.deleteByCodes(codes);
	}
	
	private PolicyPwd initDef(){
		PolicyPwd policy = new PolicyPwd();
		policy.setCode(DEF_CODE).setCaption("默认策略");
		policy.setMins(8).setMaxs(20);
		policy.setHasNum(1).setHasLesChar(1).setHasCapChar(1).setHasSpeSign(0);
		policy.setStrong(9).setDef(true);
		save(policy);
		return policy;
	}

}