package itez.plat.main.service.impl;

import itez.core.runtime.service.EModelService;
import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.kit.EStr;
import itez.core.runtime.cache.Cache;
import itez.core.runtime.service.Define;
import itez.plat.main.model.PolicyLock;
import itez.plat.main.service.PolicyLockService;

import java.util.List;

import com.google.inject.Singleton;

/**
 * 由JWinner Service Generator自动生成。
 */
@Define
@Singleton
public class PolicyLockServiceImpl extends EModelService<PolicyLock> implements PolicyLockService {

	private final static String DEF_CODE = "_DEF_";
	
	@Override
	public List<PolicyLock> selectAll() {
		List<PolicyLock> list = super.selectAllBy("def desc");
		if(list.size() == 0) list.add(initDef());
		return list;
	}
	
	@Override
	@Cache.able(cache="Policy_Lock_Code", key="'" + DEF_CODE + "'")
	public PolicyLock getPolicy() {
		Querys qs = Querys.and(Query.eq("def", true));
		PolicyLock policy = selectFirst(qs);
		if(policy == null) policy = initDef();
		return policy;
	}

	@Override
	@Cache.able(cache="Policy_Lock_Code", key="code")
	public PolicyLock getPolicy(String code) {
		PolicyLock policy = null;
		if(EStr.notEmpty(code)) policy = findByCode(code);
		if(EStr.isNull(policy)) policy = getPolicy();
		return policy;
	}
	
	@Override
	@Cache.delAll(cache="Policy_Lock_Code")
	public boolean saveOrUpdate(PolicyLock model) {
		if(EStr.isEmpty(model.getId())){
			PolicyLock exist = findByCode(model.getCode());
			if(null != exist) throw new RuntimeException("策略代码已存在！");
		}
		return super.saveOrUpdate(model);
	}
	
	@Override
	@Cache.del(cache="Policy_Lock_Code", key="codes")
	public boolean deleteByCodes(String codes) {
		return super.deleteByCodes(codes);
	}
	
	private PolicyLock initDef(){
		PolicyLock policy = new PolicyLock();
		policy.setCode(DEF_CODE).setCaption("默认策略");
		policy.setRetryCnt(6).setLockLen(60).setLockCnt(3).setDef(true);
		save(policy);
		return policy;
	}

}