package itez.plat.main.service.impl;

import itez.core.runtime.service.EModelService;
import itez.core.util.ECacheKit;
import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.kit.EArr;
import itez.kit.EDate;
import itez.kit.EStr;
import itez.kit.EUid;
import itez.kit.restful.EMap;
import itez.core.runtime.cache.Cache;
import itez.core.runtime.service.Define;
import itez.plat.main.ModuleConfig;
import itez.plat.main.model.PolicyAccount;
import itez.plat.main.service.PolicyAccountService;

import java.sql.SQLException;
import java.util.List;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import com.google.inject.Singleton;
import com.jfinal.plugin.activerecord.IAtom;
import com.jfinal.plugin.activerecord.Record;
import com.jfinal.plugin.activerecord.SqlPara;

/**
 * 由JWinner Service Generator自动生成。
 */
@Define
@Singleton
public class PolicyAccountServiceImpl extends EModelService<PolicyAccount> implements PolicyAccountService {

	private final static String DEF_ACC_NAME = "main";
	private final static String CACHE_NAME = "PolicyAcc";
	
	@Override
	public List<Record> getDefPolicys(String moduleCode) {
		EMap paras = EMap.by("domain", $domain()).set("moduleCode", moduleCode);
		SqlPara sql = dbo().getSqlPara("main.GetDefAccountPolicy", paras);
		return dbo().find(sql);
	}

	@Override
	public PolicyAccount modify(PolicyAccount acc) {
		if(EStr.isEmpty(acc.getId())){ //添加默认方案
			if(findByCode(acc.getCode()) != null) throw new RuntimeException("方案代码：" + acc.getCode() + " 已存在！");
			acc.setId(EUid.generator()).setDomain(null).setUsed(1);
			dbo().save(acc._getTable().getName(), acc.toRecord());
		}else if(EStr.isEmpty(acc.getDomain())){ //将预置方案另存为当前租户的自有方案
			acc.setId(EUid.generator()).setDomain($domain());
			save(acc);
			ECacheKit.remove(CACHE_NAME, acc.getCode());
		}else if(acc.getDomain().equals("__DEF__")){ //修改预置方案
			acc.setDomain(null);
			dbo().update(acc._getTable().getName(), acc.toRecord());
		}else{ //修改指定租户的自有方案
			String domain = acc.getDomain();
			Querys qs = Querys.and(Query.eq("domain", domain)).add(Query.eq("code", acc.getCode()));
			PolicyAccount exist = selectFirst(qs, null, false);
			if(exist == null){
				acc.setId(EUid.generator());
				save(acc);
			}else{
				update(acc);
			}
			ECacheKit.removeBase(ECacheKit.appendTenant(domain, CACHE_NAME), acc.getCode());
		}
		return acc;
	}

	@Override
	public void exportIn(String json) {
		List<PolicyAccount> adds = Lists.newArrayList();
		JSONArray arrs = JSON.parseArray(json);
		for(int i = 0, l = arrs.size(); i < l; i++){
			PolicyAccount acc = arrs.getObject(i, PolicyAccount.class);
			if(findByCode(acc.getCode()) != null) throw new RuntimeException("方案代码：" + acc.getCode() + " 已存在！");
			ECacheKit.remove(CACHE_NAME, acc.getCode());
			acc.setId(EUid.generator()).setDomain(null).setUsed(1);
			adds.add(acc);
		}
		dbo().tx(new IAtom(){
			@Override
			public boolean run() throws SQLException {
				int[] b1 = dbo().batchSave(adds, adds.size());
				return EArr.vali(b1);
			}
		});
	}

	@Override
	@Cache.able(cache = CACHE_NAME, key = "code")
	public PolicyAccount getPolicy(String code) {
		PolicyAccount acc = getPolicyBase(code);
		if(acc != null) return acc;
		if(code.equals(DEF_ACC_NAME)) acc = getDefaultMainPolicy();
		return acc;
	}
	
	/**
	 * <p>
	 * 利用互斥锁再次获取主控制台方案，防止多线程重复创建默认方案
	 * </p>
	 * 
	 * @return
	 */
	private synchronized PolicyAccount getDefaultMainPolicy(){
		PolicyAccount acc = getPolicyBase(DEF_ACC_NAME);
		if(acc == null) acc = createDefaultMainPolicy();
		return acc;
	}
	
	/**
	 * <p>
	 * 将获取指定方案的逻辑封装起来，便于复用
	 * </p>
	 * 
	 * @param code
	 * @return
	 */
	private PolicyAccount getPolicyBase(String code){
		Querys qs = Querys.and(Query.eq("code", code));
		Querys qsub = Querys.or(Query.eq("domain", $domain())).add(Querys.and(Query.nu("domain")).add(Query.eq("used", 1)));
		return selectFirst(qs.add(qsub), "domain desc, cdate desc", false);
	}
	
	/**
	 * <p>
	 * 创建主控制台默认策略
	 * </p>
	 * 
	 * @return
	 */
	private PolicyAccount createDefaultMainPolicy(){
		PolicyAccount policy = new PolicyAccount();
		policy.setId(EUid.generator()).setModuleCode(ModuleConfig.MODULE_CODE);
		policy.setCode(DEF_ACC_NAME).setCaption("主控制台");
		policy.setAppCaption("主控制台").setAppUrl("/plat").setSigninUrl("/plat/initLogin");
		policy.setEnable(true).setSessPrefix(DEF_ACC_NAME).setModes("pwd,email,weixin").setModeDef("pwd");
		policy.setPwdAuto(false).setPwdIden("loginName,email");
		policy.setPwdValiPolicy(DEF_ACC_NAME).setPwdLockPolicy(DEF_ACC_NAME);
		policy.setRegAble(false).setRegAttr("caption").setValis("").setRegMember(1);
		policy.setCdate(EDate.getDate()).setMdate(EDate.getDate()).setUsed(1);
		List<PolicyAccount> policys = Lists.newArrayList();
		policys.add(policy);
		dbo().batchSave(policys, 1);
		return policy;
	}

	@Override
	public PolicyAccount getPolicyDef(String code) {
		Querys qs = Querys.and(Query.eq("code", code)).add(Query.nu("domain")).add(Query.eq("used", 1));
		return selectFirst(qs, null, false);
	}
	
	@Override
	public void removes(String ids) {
		List<PolicyAccount> accs = findByIds(ids);
		accs.forEach(acc -> {
			if(EStr.notEmpty(acc.getDomain())){ //自定义方案
				acc.delete();
				ECacheKit.remove(CACHE_NAME, acc.getCode());
			}else{ //预置方案
				removeDefPolicy(acc.getCode());
			}
		});
	}

	@Override
	public void removeDefPolicy(String code){
		Querys qs = Querys.and(Query.eq("code", code)).add(Query.nn("domain"));
		List<PolicyAccount> accs = select(qs, null, null, false);
		if(accs.size() > 0) throw new RuntimeException("该预置方案还有租户在使用，请先清除租户的自有方案再进行删除！");
		PolicyAccount acc = getPolicyDef(code);
		acc.disable();
		ECacheKit.removeGlobal(CACHE_NAME, code);
	}

	@Override
	public List<Record> getGlobals(String code) {
		SqlPara sql = dbo().getSqlPara("main.GetGlobalPolicyAccount", EMap.by("code", code));
		List<Record> recs = dbo().find(sql);
		return recs;
	}

	@Override
	public void cleanGlobals(String code, String doms) {
		Querys qs = Querys.and(Query.eq("code", code)).add(Query.in("domain", EStr.ids2sqlIn(doms)));
		List<PolicyAccount> list = select(qs, null, null, false);
		for(PolicyAccount acc : list){
			ECacheKit.removeBase(ECacheKit.appendTenant(acc.getDomain(), CACHE_NAME), acc.getCode());
			acc.delete();
		}
	}

}