package itez.plat.main.service.impl;

import itez.core.runtime.service.EModelService;
import itez.core.util.ECacheKit;
import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.kit.EArr;
import itez.kit.EFile;
import itez.kit.EProp;
import itez.kit.EStr;
import itez.kit.EUid;
import itez.kit.poi.ECell;
import itez.kit.poi.EPoi;
import itez.kit.poi.ERow;
import itez.kit.poi.ESheet;
import itez.kit.poi.Excel;
import itez.plat.main.model.Comp;
import itez.plat.main.model.Module;
import itez.plat.main.model.Perm;
import itez.plat.main.service.ModuleService;
import itez.plat.main.service.PermService;
import itez.plat.main.service.imports.ImportsMatch;
import itez.core.runtime.cache.Cache;
import itez.core.runtime.modules.ModuleBase;
import itez.core.runtime.modules.ModuleManager;
import itez.core.runtime.service.Define;

import java.io.File;
import java.sql.SQLException;
import java.util.List;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.beust.jcommander.internal.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.jfinal.plugin.activerecord.IAtom;

/**
 * 由JWinner Service Generator自动生成。
 */
@Define
@Singleton
public class PermServiceImpl extends EModelService<Perm> implements PermService {

	@Inject
	ModuleService moduleSer;
	
	@Override
	@Cache.able(cache="PERM_BY_ID", key="id")
	public Perm findById(String id) {
		return super.findById(id);
	}

	@Override
	@Cache.able(cache="PERM_BY_IDS", key="EStr.parseArray(ids)")
	public List<Perm> findByIda(String...ids){
		return super.findByIda(ids);
	}

	@Override
	@Cache.able(cache="PERM_BY_CODE", key="code")
	public Perm findByCode(String code){
		return super.findByCode(code);
	}

	@Override
	public List<Perm> getByModule(String moduleCode) {
		Querys qs = Querys.and(Query.eq("moduleId", moduleCode));
		return select(qs);
	}

	@Override
	@Cache.able(cache="PERM_ALL", key="'COMP'")
	public List<Perm> getByComp() {
		Comp comp = (Comp)$comp();
		String moduleCodes = comp.getModules();
		Querys qs = Querys.and(Query.in("moduleId", EStr.ids2sqlIn(moduleCodes)));
		List<Perm> perms = select(qs, "moduleId, sort");
		List<Module> modules = moduleSer.getByComp();
		perms = join(perms, "moduleId", modules, "code", "caption > moduleCaption");
		return perms;
	}
	
	@Override
	@Cache.delAll(cache="PERM_BY_IDS")
	public boolean save(Perm model) {
		return super.save(model);
	}
	
	@Override
	@Cache.del(cache="PERM_BY_ID", key="model.id")
	@Cache.del(cache="PERM_BY_CODE", key="model.code")
	@Cache.delAll(cache="PERM_BY_IDS")
	@Cache.delAll(cache="PERM_ALL")
	public boolean update(Perm model) {
		return super.update(model);
	}
	
	@Override
	@Cache.del(cache="PERM_BY_ID", key="idValue")
	@Cache.delAll(cache="PERM_BY_IDS")
	@Cache.delAll(cache="PERM_BY_CODE")
	@Cache.delAll(cache="PERM_ALL")
	public boolean deleteById(String idValue) {
		return super.deleteById(idValue);
	}

	@Override
	@Cache.delAll(cache="PERM_BY_ID")
	@Cache.delAll(cache="PERM_BY_IDS")
	@Cache.delAll(cache="PERM_BY_CODE")
	@Cache.delAll(cache="PERM_ALL")
	public int imports(String moduleCode, File file, boolean repeatCode) {
		String domain = $domain();
		Excel excel = null;
		try {
			excel = EPoi.load(file);
		} catch (Exception e) {
			if(EProp.DevMode) e.printStackTrace();
			throw new RuntimeException("解析Excel文件时发送错误，请重新操作。");
		}
		ESheet sheet = excel.getSheet(0);
		int celCnt = sheet.getCellCount();
		int rowCnt = sheet.getRowCount();
		if(celCnt < 2 || rowCnt < 2) throw new RuntimeException("文件中未发现有效数据，导入失败。");
		
		ImportsMatch match = new ImportsMatch();
		match.addRequire("code").addRequire("caption").addField("summary");
		List<ERow> rows = sheet.getRows();
		match.checkMast(rows.get(0));

		List<Perm> perms = Lists.newArrayList();
		List<Perm> exists = getByModule(moduleCode);
		List<String> ids = Lists.newArrayList();
		Integer sort = 0;
		if(exists.size() > 0) sort = exists.get(exists.size() - 1).getSort();

		//开始执行导入
		for(ERow row : rows){
			if(row.getIndex() < 2) continue;
			List<ECell> cells = row.getCells();
			if(!match.checkRequire(row)) continue;
			Object codeObj = cells.get(match.getInd("code")).getValue();
			Object captionObj = cells.get(match.getInd("caption")).getValue();
			Object summaryObj = cells.get(match.getInd("summary")).getValue();
			String code = formatNum(codeObj);
			String caption = formatNum(captionObj);
			String summary = formatNum(summaryObj);
			
			Perm perm;
			Perm exist = exists.stream().filter(r -> r.getCode().equals(code)).findFirst().orElse(null);
			if(exist != null && !repeatCode) continue; //跳过已存在的

			perm = new Perm();
			perm.setId(EUid.generator()).setDomain(domain).setModuleId(moduleCode).setUsed(1);
			perm.setCode(code).setCaption(caption).setSummary(summary);
			if(exist != null){
				perm.setSort(exist.getSort());
				ids.add(exist.getId());
			}else{
				perm.setSort(sort + row.getIndex());
			}
			perms.add(perm);
		}
		if(perms.size() == 0) return 0;
		boolean state = dbo().tx(new IAtom(){
			@Override
			public boolean run() throws SQLException {
				int[] ret = dbo().batchSave(perms, perms.size());
				return EArr.vali(ret);
			}
		});
		//删除原数据
		if(state && ids.size() > 0){
			deleteByIds(ids.stream().collect(Collectors.joining(",")));
		}
		return state ? perms.size() : 0;
	}
	
	private String formatNum(Object val){
		String valStr = EStr.isEmpty(val) ? "" : val.toString();
		return valStr.replaceAll("\\.0$", "");
	}
	
	@Override
	public Perm findInCompByCode(String domain, String code) {
		Querys qs = Querys.and(Query.eq("domain", domain)).add(Query.eq("code", code));
		return selectFirst(qs, null, false);
	}

	@Override
	public void importJson(String domain, String moduleCode) {
		if(EStr.isEmpty(domain)) domain = $domain();
		
		ModuleBase module = ModuleManager.me.getModule(moduleCode);
		if(module == null) throw new RuntimeException("模块不存在！");
		
		String moduleView = module.getModuleView();
		String jsonFile = moduleView + "/init/perm.json";
		String jsonData = EFile.readInRes(jsonFile);
		if(jsonData == null) return;
		importJson(domain, moduleCode, jsonData);
		
		ECacheKit.removeAllBase(ECacheKit.appendTenant(domain, "PERM_ALL"));
		ECacheKit.removeAllBase(ECacheKit.appendTenant(domain, "PERM_BY_CODES"));
	}

	@Override
	public void importJson(String domain, String moduleCode, String json) {
		List<Perm> adds = Lists.newArrayList();
		JSONArray arrs = JSON.parseArray(json);
		for(int i = 0, l = arrs.size(); i < l; i++){
			Perm perm = arrs.getObject(i, Perm.class);
			if(findByCode(perm.getCode()) != null) continue;
			perm.setId(EUid.generator()).setDomain(domain).setModuleId(moduleCode).setUsed(1);
			adds.add(perm);
		}
		if(adds.size() == 0) return;
		dbo().tx(new IAtom(){
			@Override
			public boolean run() throws SQLException {
				int[] b1 = dbo().batchSave(adds, adds.size());
				return EArr.vali(b1);
			}
		});
	}

}