package itez.plat.main.service.impl;

import itez.core.runtime.session.EAttr;
import itez.core.runtime.session.ESessionBase;
import itez.core.wrapper.controller.EController;
import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.core.wrapper.dbo.model.Selector;
import itez.kit.EFile;
import itez.kit.EStr;
import itez.core.runtime.EContext;
import itez.core.runtime.modules.ModuleBase;
import itez.core.runtime.modules.ModuleManager;
import itez.core.runtime.service.Define;
import itez.core.runtime.service.ETreeService;
import itez.plat.main.model.Menu;
import itez.plat.main.model.Module;
import itez.plat.main.model.User;
import itez.plat.main.service.MenuService;

import java.util.List;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.beust.jcommander.internal.Lists;
import com.google.inject.Singleton;
import com.jfinal.aop.Invocation;
import com.jfinal.kit.Kv;
import com.jfinal.plugin.activerecord.SqlPara;

/**
 * 由JWinner Service Generator自动生成。
 */
@Define
@Singleton
public class MenuServiceImpl extends ETreeService<Menu> implements MenuService {

	private static final String menuActiveKey = "_m_";
	
	@Override
	public Menu findById(String id) {
		return super.findById(id);
	}

	@Override
	public List<Menu> getCompMenus(String mtype){
		return getCompMenus(mtype, null, false);
	}

	@Override
	public List<Menu> getCompMenus(String mtype, String pid){
		return getCompMenus(mtype, pid, false);
	}

	@Override
	public List<Menu> getCompMenus(String mtype, String pid, String moduleCode){
		return getCompMenus(mtype, pid, moduleCode, false);
	}

	@Override
	public List<Menu> getCompMenus(String mtype, String pid, boolean minMode){
		return getCompMenus(mtype, pid, null, minMode);
	}

	@Override
	public List<Menu> getCompMenus(String mtype, String pid, String moduleCode, boolean minMode){
		Querys qs = Querys.and(Query.eq("mtype", mtype));
		qs.add(pid == null ? Query.nu("pid") : Query.eq("pid", pid));
		if(EStr.notEmpty(moduleCode)) qs.add(Query.eq("moduleCode", moduleCode));
		List<Menu> menus = select(Selector.select().where(qs));
		List<Menu> ables = Lists.newArrayList();
		menus.forEach(menu -> {
			if(menu.authCheck()){
				if(menu.getFolder() == 1){
					List<Menu> subs = getCompMenus(mtype, menu.getId(), moduleCode, minMode);
					if(null != subs && subs.size() > 0){
						menu.put("sub", subs);
					}
				}
				if(minMode) menu.keep("id", "ico", "caption", "folder", "command", "moduleCode", "sub", "authMode", "authCode");
				ables.add(menu);
			}
		});
		return ables;
	}

	@Override
	public List<Menu> getMenuTree(String mtype){
		return getMenuTree(mtype, null);
	}

	@Override
	public List<Menu> getMenuTree(String mtype, String module){
		return getMenuTree(mtype, module, null);
	}

	@Override
	public List<Menu> getMenuTree(String mtype, String moduleCode, String domain){
		if(EStr.isEmpty(domain)) domain = $domain();
		Querys qs = Querys.and(Query.eq("mtype", mtype)).add(Query.eq("domain", domain));
		if(EStr.notEmpty(moduleCode)) qs.add(Query.eq("moduleCode", moduleCode));
		List<Menu> menus = select(qs, "path", null, false);
		return menus;
	}

	@Override
	public Menu getLastMenu(String mtype, String pid){
		return getLastMenu($domain(), mtype, pid);
	}

	@Override
	public Menu getLastMenu(String domain, String mtype, String pid){
		Querys qs = Querys.and(Query.eq("mtype", mtype)).add(Query.eq("domain", domain));
		return super.getLast(domain, qs, pid);
	}

	@Override
	public void sort(String mtype, String pid, String dir, String ids){
		Querys qs = Querys.and(Query.eq("mtype", mtype));
		super.sort(qs, pid, SORT_DIR.valueOf(dir), ids);
	}

	@Override
	public void init(String domain, String mtype, String moduleCode){
		if(EStr.isEmpty(domain)) domain = $domain();
		if(EStr.isEmpty(mtype)) mtype = "menu";
		ModuleBase module = ModuleManager.me.getModule(moduleCode);
		if(module == null) throw new RuntimeException("模块不存在！");
		
		String moduleView = module.getModuleView();
		String moduleMenu = moduleView + "/" + mtype + ".json";
		String menuJson = EFile.readInRes(moduleMenu);
		if(menuJson == null) return;
		
		List<Menu> menus = getMenuTree(mtype, moduleCode, domain);
		if(menus.size() > 0) return;
		//delMenuByModule(domain, mtype, moduleCode);
		
		JSONArray roots = JSON.parseArray(menuJson);
		initLevel(domain, mtype, moduleCode, null, roots);
	}
	
	private void initLevel(String domain, String mtype, String moduleCode, String pid, JSONArray menus){
		for(int i=0, cnt=menus.size(); i<cnt; i++){
			JSONObject menuJson = menus.getJSONObject(i);
			String ico = menuJson.getString("ico");
			String caption = menuJson.getString("caption");
			Integer folder = menuJson.getInteger("folder");
			String command = menuJson.getString("command");
			String authMode = menuJson.getString("authMode");
			String authCode = menuJson.getString("authCode");
			
			Menu parent = EStr.isEmpty(pid) ? null : findById(pid);
			Menu last = getLastMenu(domain, mtype, pid);
			Integer sort = last == null ? 1 : last.getSort() + 1;
			String path = parent == null ? EStr.addPrefix(sort, 3) : String.format("%s_%s", parent.getPath(), EStr.addPrefix(sort, 3));
			Menu menu = new Menu();
			menu.setDomain(domain);
			menu.setMtype(mtype);
			menu.setModuleCode(moduleCode);
			menu.setPid(pid);
			menu.setIco(ico);
			menu.setCaption(caption);
			menu.setCommand(command);
			menu.setAuthMode(authMode);
			menu.setAuthCode(authCode);
			menu.setFolder(folder);
			menu.setSort(sort);
			menu.setPath(path);
			save(menu);
			
			JSONArray subs = menuJson.getJSONArray("sub");
			if(subs != null && subs.size() > 0) initLevel(domain, mtype, moduleCode, menu.getId(), subs);
		}
	}

	@Override
	public Boolean interceptorMenu(Invocation inv, String mtype){
		EController controller = (EController)inv.getController();
		EAttr attr = EContext.getAttr();
		ESessionBase sess = EContext.getSession();
		User user = (User)sess.getUser();
		if(user == null) return true; //匿名用户，已经过AuthInterceptor授权检验，不再进行判断
		
		String moduleIds = user.getModuleIds();
		List<Module> modules = user.getModules(moduleIds);
		List<Menu> menus = getCompMenus(mtype, null, null, true);
				
		String clickMenu = controller.getPara(menuActiveKey);
		if(EStr.notEmpty(clickMenu)){
			if(clickMenu.equals("_index_")) clickMenu = "";
			sess.setAttribute(menuActiveKey, clickMenu);
		}else{
			clickMenu = sess.getAttr(menuActiveKey);
		}
				
		if(EStr.notEmpty(clickMenu)){
			int at = clickMenu.lastIndexOf("_");
			at = at == -1 ? 0 : at + 1;
			String menuId = clickMenu.substring(at);
			Menu menu = findById(menuId);
			if(menu != null){
				String menuActiveName = menu.getCaption();
				String[] moduleCodes = moduleIds.split(",");
				if(EStr.findInArr(moduleCodes, menu.getModuleCode()) == -1) return false;
				attr.setItem("currentMenuId", clickMenu);
				attr.setItem("currentMenuName", menuActiveName);
				attr.setItem("currentMenuStr", String.format("%s=%s", menuActiveKey, clickMenu));
			}
		}
		
		attr.setItem("modulesData", modules);
		attr.setItem("menusData", menus);
		return true;
	}
	
	@Override
	public void sessMenuClear() {
		EContext.getSession().setAttribute(menuActiveKey, "");
	}

	@Override
	public void delMenuByPath(String mtype, String path) {
		SqlPara sql = dbo().getSqlPara("main.delMenuByPath", Kv.by("domain", $domain()).set("mtype", mtype).set("path", path));
		dbo().update(sql);
	}

	@Override
	public void delMenuByModule(String domain, String mtype, String moduleCode) {
		if(EStr.isEmpty(domain)) domain = $domain();
		if(EStr.isEmpty(mtype)) mtype = "menu";
		SqlPara sql = dbo().getSqlPara("main.cleanMenuByModule", Kv.by("moduleCode", moduleCode).set("domain", domain));
		dbo().update(sql);
	}

}