package itez.plat.main.service.impl;

import itez.core.runtime.service.EModelService;
import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.kit.EDate;
import itez.core.runtime.service.Define;
import itez.plat.main.model.Leaved;
import itez.plat.main.service.LeavedService;
import com.google.inject.Singleton;
import com.jfinal.kit.Kv;
import com.jfinal.plugin.activerecord.Record;
import com.jfinal.plugin.activerecord.SqlPara;

/**
 * 由JWinner Service Generator自动生成。
 */
@Define
@Singleton
public class LeavedServiceImpl extends EModelService<Leaved> implements LeavedService {

	@Override
	public void userLeave(String id) {
		Leaved leaved = new Leaved();
		leaved.setUid(id).setLeavedDate(EDate.getDate()).setLeavedDays(0).setReturned(0);
		save(leaved);
	}

	@Override
	public void userBack(String id) {
		Querys qs = Querys.and(Query.eq("uid", id)).add(Query.eq("returned", 0));
		Leaved leaved = selectFirst(qs);
		if(leaved == null) return;
		leaved.setReturnDate(EDate.getDate());
		leaved.setReturned(1);
		leaved.setLeavedDays((int)EDate.diff(leaved.getLeavedDate(), leaved.getReturnDate()).toDays());
		update(leaved);
	}

	@Override
	public int getUserLeavedDays(String id) {
		int days = 0;
		Kv paras = Kv.by("uid", id);
		SqlPara sqlPara = dbo().getSqlPara("main.userLeavedDays", paras);
		Record rec = dbo().findFirst(sqlPara);
		days = rec.getInt("cnt");
		return days;
	}

}