package itez.plat.main.service.impl;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.beust.jcommander.internal.Lists;
import com.beust.jcommander.internal.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.jfinal.kit.HashKit;
import com.jfinal.kit.Kv;
import com.jfinal.plugin.activerecord.Db;
import com.jfinal.plugin.activerecord.DbPro;
import com.jfinal.plugin.activerecord.IAtom;
import com.jfinal.plugin.activerecord.Record;
import com.jfinal.plugin.activerecord.generator.ColumnMeta;
import com.jfinal.plugin.activerecord.generator.TableMeta;

import itez.core.runtime.EContext;
import itez.core.runtime.service.Define;
import itez.core.runtime.service.EService;
import itez.core.wrapper.dbo.DbUtil;
import itez.kit.EArr;
import itez.kit.EDate;
import itez.kit.EJson;
import itez.kit.ELog;
import itez.kit.EProp;
import itez.kit.ERet;
import itez.kit.EStr;
import itez.kit.EUid;
import itez.kit.El;
import itez.kit.exception.ExceptionKit;
import itez.kit.poi.ECell;
import itez.kit.poi.Excel;
import itez.kit.poi.ERow;
import itez.kit.poi.ESheet;
import itez.plat.main.service.FormCacheService;
import itez.plat.main.service.ImportService;

@Define
@Singleton
public class ImportSeviceImpl extends EService implements ImportService {
	
	public static final String COLS_KEY_FIELD = "field";
	public static final String COLS_KEY_TYPE = "type";
	public static final String COLS_KEY_MODE = "mode";
	public static final String COLS_KEY_EXPR = "expr";
	private static final String FormCacheCode = "import";
	
	@Inject
	FormCacheService formSer;

	//忽略导入字段列表
	private Map<String, Boolean> ignoreFields;
	
	@Override
	public Map<String, Boolean> getIgnoreFields(){
		if(ignoreFields == null){
			ignoreFields = Maps.newHashMap();
			ignoreFields.put("id", Boolean.TRUE);
			ignoreFields.put("domain", Boolean.TRUE);
			ignoreFields.put("cdate", Boolean.TRUE);
			ignoreFields.put("mdate", Boolean.TRUE);
			ignoreFields.put("rdate", Boolean.TRUE);
			ignoreFields.put("used", Boolean.TRUE);
			ignoreFields.put("salt", Boolean.TRUE);
		}
		return ignoreFields;
	}

	@Override
	public TableMeta parseModel(String clazz, String[] dbConfig){
		TableMeta tableMeta = DbUtil.getTableMeta(clazz, dbConfig);
		return tableMeta;
	}

	@Override
	public Integer apply(String clazz, Excel excel, Integer sheetIndex, Integer ignoreHeaders, String[] fields, String[] modes, String[] exprs){
		ESheet sheet = excel.getSheet(sheetIndex);
		String[] dbConfig = {"", ""};
		TableMeta tableMeta = parseModel(clazz, dbConfig);
		String config = dbConfig[0];
		String table = dbConfig[1];
		for(ColumnMeta col : tableMeta.columnMetas){
			int ind = EStr.findInArr(fields, col.name);
			if(ind != -1){
				col.defaultValue = exprs[ind];
			}else{
				col.defaultValue = null;
			}
		}
		List<Record> imps = Lists.newArrayList();
		for(int i=ignoreHeaders; i<sheet.getRowCount(); i++){
			Record rec = generatRow(sheet.getRow(i), tableMeta);
			imps.add(rec);
		}
		int cnt = imps.size();
		if(cnt == 0) return 0;
		
		boolean act = false;
		try {
			DbPro db = Db.use(config);
			act = db.tx(new IAtom() {
				@Override
				public boolean run() throws SQLException {
					int[] result = db.batchSave(table, imps, cnt);
					return EArr.vali(result);
				}
			});
		} catch (Exception e) {
			if(EProp.DevMode) e.printStackTrace();
			ELog.error(ImportSeviceImpl.class, "导入数据发生错误");
			ELog.error(ImportSeviceImpl.class, ExceptionKit.getExceptionMore(e));
		}
		return act ? cnt : 0;
	}

	@Override
	public Kv getFormCache(String clazz, String params){
		String key = EStr.isEmpty(params) ? clazz : clazz.concat(params);
		String data = formSer.getCacheData(EContext.getAttr().getModuleCode(), FormCacheCode, key);
		if(data == null) return null;
		JSONObject obj = JSON.parseObject(data);
		JSONArray fields = obj.getJSONArray("fields");
		JSONArray modes = obj.getJSONArray("modes");
		JSONArray exprs = obj.getJSONArray("exprs");
		Kv kv = Kv.create();
		for(int i=0; i<fields.size(); i++) kv.set(fields.getString(i), Kv.by("mode", modes.getString(i)).set("expr", exprs.getString(i)));
		return kv;
	}

	@Override
	public void putFormCache(String clazz, String params, String[] fields, String[] modes, String[] exprs){
		String key = clazz.concat(params);
		Kv data = Kv.create().set("fields", fields).set("modes", modes).set("exprs", exprs);
		String dataStr = EJson.toJson(data);
		formSer.putCache(EContext.getAttr().getModuleCode(), FormCacheCode, key, dataStr);
	}

	public Record generatRow(ERow row, TableMeta tableMeta){
		List<ECell> cells = row.getCells();
		ERet context = ERet.create("cells", cells).set("index", row.getIndex());
		Map<String, Boolean> ignores = getIgnoreFields();
		Record rec = new Record();
		String salt = null;
		for(ColumnMeta col : tableMeta.columnMetas){
			String field = col.name;
			String expr = col.defaultValue;
			Object val = null;
			if(ignores.get(field) != null){
				if(field.equals("id")){
					val = EUid.generator();
				}else if(field.equals("domain")){
					val = $domain();
				}else if(field.equals("cdate")){
					val = EDate.getDate();
				}else if(field.equals("mdate")){
					val = null;
				}else if(field.equals("used")){
					val = 1;
				}else if(field.equals("salt")){
					if(salt == null) salt = HashKit.generateSaltForSha512();
					val = salt;
				}
			}else if(expr != null){
				try {
					val = El.exec(expr, context);
					if(field.equals("loginPass")){
						if(salt == null) salt = HashKit.generateSaltForSha512();
						val = HashKit.md5(val + salt);
					}
				} catch (Exception e) {
					if(EProp.DevMode) e.printStackTrace();
					ELog.error(ImportSeviceImpl.class, "解析公式发生错误：{}", expr);
				}
			}
			rec.set(field, val);
		}
		return rec;
	}
	
	/*
	public void parseModel(String clazz, String[] dbConfig, List<ERet> colList){
		TableMeta tableMeta = DbUtil.getTableMeta(clazz);
		EModel<?> model = (EModel<?>)EClass.newInstance(clazz);
		Table table = model._getTable();
		dbConfig[0] = model.getConfig().getName();
		dbConfig[1] = table.getName();
		Set<String> cols = table.getColumnNameSet();
		for(String col : cols){
			Class<?> colType = table.getColumnType(col);
			String colTypeName = colType.getSimpleName();
			colList.add(ERet.create(COLS_KEY_FIELD, col).set(COLS_KEY_TYPE, colTypeName));
		}
	}
	
	public Integer apply(String clazz, Excel excel, Integer sheetIndex, String[] fields, String[] modes, String[] exprs){
		Sheet sheet = excel.getSheet(sheetIndex);
		String[] dbConfig = {"", ""};
		List<ERet> colList = Lists.newArrayList();
		parseModel(clazz, dbConfig, colList);
		String config = dbConfig[0];
		String table = dbConfig[1];
		for(ERet col : colList){
			int ind = EStr.findInArr(fields, col.getStr(COLS_KEY_FIELD));
			if(ind != -1){
				col.set(COLS_KEY_MODE, modes[ind]);
				col.set(COLS_KEY_EXPR, exprs[ind]);
			}else{
				col.set(COLS_KEY_MODE, null);
				col.set(COLS_KEY_EXPR, null);
			}
		}
		List<Record> imps = Lists.newArrayList();
		for(int i=0; i<sheet.getRowCount(); i++){
			Record rec = generatRow(sheet.getRow(i), colList);
			imps.add(rec);
		}
		int[] result = Db.use(config).batchSave(table, imps, 200);
		return result.length;
	}
	
	@SuppressWarnings("unused")
	private Record generatRow(Row row, List<ERet> colList){
		List<Cell> cells = row.getCells();
		ERet context = ERet.create("cells", cells).set("index", row.getIndex());
		Map<String, Boolean> ignores = getIgnoreFields();
		Record rec = new Record();
		String salt = null;
		for(ERet col : colList){
			String field = col.getStr(COLS_KEY_FIELD);
			String type = col.getStr(COLS_KEY_TYPE);
			String mode = col.getStr(COLS_KEY_MODE);
			String expr = col.getStr(COLS_KEY_EXPR);
			Object val = null;
			if(ignores.get(field) != null){
				if(field.equals("id")){
					val = EUid.generator();
				}else if(field.equals("domain")){
					val = $domain();
				}else if(field.equals("cdate")){
					val = EDate.getDate();
				}else if(field.equals("mdate")){
					val = null;
				}else if(field.equals("used")){
					val = 1;
				}else if(field.equals("salt")){
					if(salt == null) salt = HashKit.generateSaltForSha512();
					val = salt;
				}
			}else if(expr != null){
				val = El.me.exec(expr, context);
				if(field.equals("loginPass")){
					if(salt == null) salt = HashKit.generateSaltForSha512();
					val = HashKit.md5(val + salt);
				}
			}
			rec.set(field, val);
		}
		return rec;
	}
	*/
	
}
