package itez.plat.main.service.impl;

import itez.core.runtime.service.EModelService;
import itez.core.runtime.service.common.IUser;
import itez.kit.EStr;
import itez.kit.fileup.FileItem;
import itez.core.runtime.service.Define;
import itez.plat.main.model.FileStore;
import itez.plat.main.service.FileStoreService;
import com.google.inject.Singleton;

/**
 * 由JWinner Service Generator自动生成。
 */
@Define
@Singleton
public class FileStoreServiceImpl extends EModelService<FileStore> implements FileStoreService {

	@Override
	public FileStore append(FileItem fileItem) {
		return append(fileItem, fileItem.getFileName());
	}

	@Override
	public FileStore append(FileItem fileItem, String displayName) {
		IUser user = $user();
		String fileName = fileItem.getFileName();
		if(EStr.isEmpty(displayName)) displayName = fileName;
		if(displayName.indexOf(".") == -1) displayName = String.join(".", displayName, fileItem.getExtName());
		FileStore store = new FileStore();
		store.setFileName(fileName).setDisplayName(displayName);
		store.setExtName(fileItem.getExtName()).setFileSize(fileItem.getFileSize());
		store.setFilePath(fileItem.getFilePath()).setFileUrl(fileItem.getUrl());
		store.setDownCnt(0).setCuid(user.getId()).setCuname(user.getCaption());
		save(store);
		return store;
	}

	@Override
	public FileStore downAdd(String id) {
		FileStore store = findById(id);
		store.setDownCnt(store.getDownCnt() + 1);
		update(store);
		return store;
	}

}