package itez.plat.main.service.impl;

import itez.core.runtime.service.EModelService;
import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.kit.ERegex;
import itez.kit.EStr;
import itez.plat.main.model.DrawingElement;
import itez.plat.main.service.DrawingElementService;
import itez.core.runtime.service.Define;

import java.util.Arrays;
import java.util.List;
import java.util.Set;

import com.beust.jcommander.internal.Sets;
import com.google.inject.Singleton;
import com.jfinal.kit.Kv;

/**
 * 由JWinner Service Generator自动生成。
 */
@Define
@Singleton
public class DrawingElementServiceImpl extends EModelService<DrawingElement> implements DrawingElementService {

	@Override
	public List<DrawingElement> getByModelId(String modelId) {
		return getByModelId(modelId, false);
	}
	
	@Override
	public List<DrawingElement> getByModelId(String modelId, boolean showHide) {
		Querys qs = Querys.and(Query.eq("modelId", modelId));
		if(!showHide) qs.add(Query.eq("visible", 1));
		return select(qs, "visible desc, sort");
	}

	@Override
	public Kv parseFromString(String txt){
		Kv kv = Kv.create();
		if(EStr.isEmpty(txt)) return kv;
		String[] strs = txt.split("\\n");
		Arrays.stream(strs).forEach(i -> {
			if(EStr.notEmpty(i)){
				i = i.replace(" ", "").replace("\r", "").replace("\n", "");
				int at = i.indexOf(":");
				kv.set(i.substring(0,  at), i.substring(at+1, i.length()));
			}
		});
		return kv;
	}

	@Override
	public Set<String> getKey4Data(String modelId) {
		return getKey4Data(getByModelId(modelId));
	}

	@Override
	public Set<String> getKey4Data(List<DrawingElement> els) {
		Set<String> set = Sets.newHashSet();
		els.forEach(el -> {
			String val = el.getValue();
			if(EStr.notEmpty(val)){
				String[] matches = ERegex.findAll(val, "data.get\\(\"([A-Za-z0-9_]+)\"\\)");
				if(matches != null && matches.length > 0) Arrays.stream(matches).forEach(d -> { set.add(d); });
			}
		});
		return set;
	}

	@Override
	public Set<String> getKey4Para(String modelId) {
		return getKey4Para(getByModelId(modelId));
	}

	@Override
	public Set<String> getKey4Para(List<DrawingElement> els) {
		Set<String> set = Sets.newHashSet();
		els.forEach(el -> {
			String val = el.getValue();
			if(EStr.notEmpty(val)){
				String[] matches = ERegex.findAll(val, "para.get\\(\"([A-Za-z0-9_]+)\"\\)");
				if(matches != null && matches.length > 0) Arrays.stream(matches).forEach(d -> { set.add(d); });
			}
		});
		return set;
	}

	@Override
	public String parseFromSet(Set<String> keys) {
		StringBuilder str = new StringBuilder();
		keys.stream().forEach(d -> { str.append(d).append(" : \\n"); });
		return str.toString();
	}

}