package itez.plat.main.service.impl;

import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.kit.EArr;
import itez.kit.EPara;
import itez.kit.EProp;
import itez.kit.EStr;
import itez.kit.EUid;
import itez.kit.poi.ECell;
import itez.kit.poi.EPoi;
import itez.kit.poi.ERow;
import itez.kit.poi.ESheet;
import itez.kit.poi.Excel;
import itez.kit.restful.EMap;
import itez.core.runtime.cache.Cache;
import itez.core.runtime.service.Define;
import itez.core.runtime.service.ETreeService;
import itez.plat.main.model.Dept;
import itez.plat.main.service.DeptService;

import java.io.File;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

import org.apache.commons.lang3.ArrayUtils;

import com.beust.jcommander.internal.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Singleton;
import com.jfinal.kit.Kv;
import com.jfinal.plugin.activerecord.IAtom;
import com.jfinal.plugin.activerecord.Record;
import com.jfinal.plugin.activerecord.SqlPara;

/**
 * 由JWinner Service Generator自动生成。
 */
@Define
@Singleton
public class DeptServiceImpl extends ETreeService<Dept> implements DeptService {

	@Override
	@Cache.able(cache="DEPT_BY_ID", key="id")
	public Dept findById(String id) {
		return super.findById(id);
	}
		
	/**
	 * 创建默认部门
	 * @param comp
	 * @return
	 */
	@Override
	public Dept createRootDept(){
		Dept dept = new Dept();
		dept.setCaption($comp().getCaption());
		dept.setSummary("默认部门");
		dept.setSort(1);
		dept.setPath(EStr.addPrefix(1, 3));
		Querys qs = Querys.and(Query.nu("pid"));
		Dept exist = selectFirst(qs);
		if(exist == null){
			save(dept);
			return dept;
		}else{
			return exist;
		}
	}

	@Override
	public Dept getRootDept(){
		Querys qs = Querys.and(Query.nu("pid"));
		Dept dept = selectFirst(qs);
		if(dept == null) dept = getRootDeptSync();
		return dept;
	}
	
	
	private synchronized Dept getRootDeptSync(){
		Querys qs = Querys.and(Query.nu("pid"));
		Dept dept = selectFirst(qs);
		if(dept == null) dept = createRootDept();
		return dept;
	}
	
	
	
	//////////////////////////////////////////////// 最基本的机构查询方法 /////////////////////////////////////////////
	


	@Override
	public List<Dept> getDeptTree(){
		return getDeptTree(null);
	}

	@Override
	public List<Dept> getDeptTree(String rootId){
		return getDeptTree(rootId, false);
	}
	
	@Override
	public List<Dept> getDeptTree(String rootId, boolean includeLogic){
		Dept root = getRootDept();
		Dept dept = EStr.isEmpty(rootId) ? root : findById(rootId);
		Querys qs = Querys.and(Query.like("path", dept.getPath() + "%"));
		List<Dept> depts = select(qs, "path", null, "id", "pid", "typeCode", "typeCaption", "code", "caption", "abbr", "path", "logic", "index");
		if(dept.getId().equals(root.getId())) includeLogic = false; //如果返回全部机构树形，因为所有机构都已经包括在内，则无需解析逻辑机构
		if(includeLogic) fillLogicDept(depts);
		return depts;
	}
	
	
	
	//////////////////////////////////////////////// 返回扁平模式（非树型）的机构列表 /////////////////////////////////////////////
	
	

	@Override
	public List<Dept> getSubDepts(){
		return getSubDepts(null);
	}

	@Override
	public List<Dept> getSubDepts(String pid){
		return getSubDepts(pid, null);
	}

	@Override
	public List<Dept> getSubDepts(String pid, String typeCode){
		if(EStr.isEmpty(pid)) pid = getRootDept().getId();
		Querys qs = Querys.and(Query.eq("pid", pid));
		if(EStr.notEmpty(typeCode)) qs.add(Query.in("typeCode", EStr.ids2sqlIn(typeCode)));
		return select(qs);
	}
	
	
	
	//////////////////////////////////////////////// 返回上级机构   /////////////////////////////////////////////
	
	
	

	@Override
	public Dept getParent(String id){
		Dept dept = findById(id);
		return EStr.isEmpty(dept.getPid()) ? dept : findById(dept.getPid());
	}

	@Override
	public Dept getParent(String id, String typeCode){
		Dept dept = findById(id);
		EMap paras = EMap.by("domain", $domain()).set("typeCode", typeCode).set("path", dept.getPath()).set("sort", "desc");
		SqlPara sql = dbo().getSqlPara("main.getParentDeptByPath", paras);
		Record rec = dbo().findFirst(sql);
		if(rec == null) return null;
		Dept par = new Dept();
		par._setAttrs(rec.getColumns());
		return par;
	}
	
	
	
	
	
	//////////////////////////////////////////////// 查找下级机构   /////////////////////////////////////////////

	
	

	@Override
	public List<Dept> getChildrens(String typeCode) {
		return getChildrens(typeCode, null);
	}
	
	@Override
	public List<Dept> getChildrens(String typeCode, String rootId) {
		List<Dept> depts = getDeptTree(rootId, false);
		if(EStr.isEmpty(typeCode)) return depts;
		String[] codes = typeCode.split(",");
		ListIterator<Dept> listIt = depts.listIterator();
		while(listIt.hasNext()){
			Dept d = listIt.next();
			String code = d.getTypeCode();
			if(EStr.isEmpty(code)) listIt.remove();
			else if(!ArrayUtils.contains(codes, code)) listIt.remove();
		}
		return depts;
	}
	
	
	
	
	//////////////////////////////////////////////// 逻辑机构相关方法  /////////////////////////////////////////////
	
	


	@Override
	public List<Dept> fillLogicDept(List<Dept> depts) {
		Map<String, Dept> deptMap = Maps.newHashMap();
		ListIterator<Dept> listIt = depts.listIterator();
		while(listIt.hasNext()){
			Dept d = listIt.next();
			if(d.getLogic() == 0) continue;
			Dept dl = deptMap.get(d.getLogicId());
			if(dl == null){
				dl = findById(d.getLogicId());
				deptMap.put(d.getLogicId(), dl);
			}
			String path = d.getPath();
			d._setAttrs(dl).setPath(path).setLogic(1);
			listIt.set(d);
			List<Dept> subs = getDeptTree(dl.getId(), true);
			for(Dept ds : subs){
				ds.setPath(ds.getPath().replace(dl.getPath(), path));
				listIt.add(ds);
			}
		}
		depts.sort((a, b) -> {
			String pathA = a.getPath(), pathB = b.getPath();
			return pathA.compareTo(pathB);
		});
		return depts;
	}
	
	@Override
	public List<Dept> getLogicTo(String id) {
		Querys qs = Querys.and(Query.eq("logicId", id));
		return select(qs);
	}
	
	

	
	//////////////////////////////////////////////// 其他方法  /////////////////////////////////////////////
	
	

	

	@Override
	public Dept getLastDept(String pid){
		return super.getLast(pid);
	}

	@Override
	public void event(Dept data) {
		//真实机构进行代码查重
		if(data.getLogic() == 0 && EStr.notEmpty(data.getCode())){
			Dept exist = findByCode(data.getCode());
			if(exist != null && EStr.isEmpty(data.getId())) throw new RuntimeException("部门代码（" + data.getCode() + "）已存在！");
			else if(exist != null && !data.getId().equals(exist.getId())) throw new RuntimeException("部门代码（" + data.getCode() + "）已存在！");
		}
		if(EStr.isEmpty(data.getId())){ //添加
			addDept(data);
			arrange(null, data.getId());
			//逻辑机构进行互斥校验（逻辑机构功能过于复杂，难以维护，停止使用）
			//if(data.getLogic() == 1 && chkLogicLoop(data.getLogicId(), path)) throw new RuntimeException("逻辑部门指向重复！");
		}else{ //修改
			modifyDept(data);
			//同步修改引用该机构的逻辑节点（逻辑机构功能过于复杂，难以维护，停止使用）
			//List<Dept> logics = getLogicTo(id);
			//for(Dept d : logics){
			//	d.setCaption(data.getCaption());
			//	modifyDept(d);
			//}
		}
	}
	
	@Override
	@Cache.delAll(cache="DEPT_BY_ID")
	public void eventBatch(EPara paras) {
		String ids = paras.get("ids");
		String typeCode = paras.get("typeCode");
		String typeCaption = paras.get("typeCaption");
		String index = paras.get("index");
		String gpsCoords = paras.get("gpsCoords");
		String gpsRadius = paras.get("gpsRadius");
		List<Dept> depts = findByIds(ids);
		depts.forEach(d -> {
			d.setTypeCode(typeCode).setTypeCaption(typeCaption);
			d.setGpsCoords(gpsCoords).setGpsRadius(gpsRadius);
			d.setIndex(index);
		});
		batchUpdate(depts);
	}

	@Override
	public void addDept(Dept dept){
		save(dept);
	}

	@Override
	@Cache.delAll(cache="DEPT_BY_ID")
	public void modifyDept(Dept dept){
		update(dept);
	}

	@Cache.delAll(cache="DEPT_BY_ID")
	public void removeDepts(String ids){
		Querys qs = Querys.and(Query.in("pid", EStr.ids2sqlIn(ids)));
		List<Dept> subs = select(qs);
		if(subs.size() > 0) throw new RuntimeException("所选部门下还有子部门，请先删除子部门！");
		disableByIds(ids);
	}
	
	/**
	 * <p>
	 * 返回逻辑部门
	 * </p>
	 * 
	 * @param pid
	 * @return
	 */
	private List<Dept> getLogicDepts(String pid){
		Querys qs = Querys.and(Query.eq("logic", 1));
		if(EStr.notEmpty(pid)){
			Dept par = findById(pid);
			qs.add(Query.like("path", par.getPath() + "_%"));
		}
		List<Dept> depts = select(qs);
		return depts;
	}
	
	/**
	 * <p>
	 * 判断当前逻辑部门指向的真实部门是否存在回调的子逻辑部门，会造成指向互斥
	 * </p>
	 * 
	 * @param toId 指向的真实部门ID
	 * @param logicPath 当前逻辑部门的路径
	 * @return true：存在互斥，false：不存在
	 */
	@SuppressWarnings("unused")
	private boolean chkLogicLoop(String toId, String logicPath){
		List<Dept> depts = getLogicDepts(toId);
		if(depts.size() == 0) return false;
		for(Dept logic : depts){
			if(logicPath.startsWith(logic.getLogicPath())) return true;
			if(chkLogicLoop(logic.getLogicId(), logicPath)) return true;
		}
		return false;
	}

	@Cache.delAll(cache="DEPT_BY_ID")
	public void sort(String pid, String opt, String ids){
		super.sort(pid, SORT_DIR.valueOf(opt), ids);
		
		//调整排序后，需要对全部逻辑部门进行同步
		/*
		Map<String, Dept> deptMap = Maps.newHashMap();
		List<Dept> depts = getLogicDepts(null);
		for(Dept d : depts){
			Dept dl = deptMap.get(d.getLogicId());
			if(dl == null){
				dl = findById(d.getLogicId());
				deptMap.put(d.getLogicId(), dl);
			}
			d.setLogicPath(dl.getPath());
			modifyDept(d);
		}
		*/
	}

	@Override
	public int imports(String pid, File file){
		String domain = $domain();
		Excel excel = null;
		try {
			excel = EPoi.load(file);
		} catch (Exception e) {
			if(EProp.DevMode) e.printStackTrace();
			throw new RuntimeException("解析Excel文件时发送错误，请重新操作。");
		}
		ESheet sheet = excel.getSheet(0);
		int celCnt = sheet.getCellCount();
		int rowCnt = sheet.getRowCount();
		if(celCnt < 2 || rowCnt < 2) throw new RuntimeException("文件中未发现有效数据，导入失败。");
		String[] fields = { "parentDept", "dept" };
		Map<String, Integer> fieldIndex = Maps.newHashMap();
		List<ERow> rows = sheet.getRows();

		//数据列对照
		ERow header = rows.get(0);
		header.getCells().forEach(cell -> {
			Object val = cell.getValue();
			if(val != null){
				String caption = val.toString();
				if(ArrayUtils.contains(fields, caption)){
					fieldIndex.put(caption, cell.getCellIndex());
				}
			}
		});
		
		//必要数据列预审
		StringBuilder sb = new StringBuilder();
		Arrays.stream(fields).forEach(f -> {
			if(!fieldIndex.containsKey(f)){
				sb.append("，").append(f);
			}
		});
		if(sb.length() > 0) throw new RuntimeException("缺少必要数据列：" + sb.substring(1));

		Dept rootDept = findById(pid);
		Dept rootLast = getLastDept(pid);
		List<Dept> depts = Lists.newArrayList();
		Map<String, Kv> deptMap = Maps.newHashMap();
		depts.add(rootDept);
		deptMap.put(rootDept.getCaption(), Kv.by("index", 0).set("size", rootLast == null ? 0 : rootLast.getSort()));
		
		//开始执行导入
		for(ERow row : rows){
			if(row.getIndex() < 2) continue;
			List<ECell> cells = row.getCells();
			Object parentDeptObj = cells.get(fieldIndex.get("parentDept")).getValue();
			Object deptObj = cells.get(fieldIndex.get("dept")).getValue();
			
			if(EStr.isEmpty(parentDeptObj) || EStr.isEmpty(deptObj)) continue;
			
			String parentDeptCaption = formatNum(parentDeptObj);
			String deptCaption = formatNum(deptObj);
			
			if(parentDeptCaption.equals("[根机构]")) parentDeptCaption = rootDept.getCaption();
			
			Dept parentDept;
			String parentPath;
			int index, parentSize;
			
			Kv kv = deptMap.get(parentDeptCaption);
			if(kv == null) continue;
			
			index = kv.getInt("index");
			parentDept = depts.get(index);
			parentPath = parentDept.getPath();
			parentSize = kv.getInt("size");
			
			Dept dept = new Dept();
			dept.setDomain(domain);
			dept.setPid(parentDept.getId());
			dept.setId(EUid.generator());
			dept.setCaption(deptCaption);
			dept.setLevel(1);
			dept.setSort(++parentSize);
			dept.setPath(parentPath.concat("_").concat(EStr.addPrefix(dept.getSort(), 3)));
			dept.setUsed(1);

			depts.add(dept);
			deptMap.put(parentDeptCaption, kv.set("size", parentSize));
			deptMap.put(deptCaption, Kv.by("index", depts.size() - 1).set("size", 0));
		}
		
		depts.remove(0);
		
		if(depts.size() == 0) return 0;
		
		boolean state = dbo().tx(new IAtom(){
			@Override
			public boolean run() throws SQLException {
				int[] ret = dbo().batchSave(depts, depts.size());
				return EArr.vali(ret);
			}
		});
		
		return state ? depts.size() : 0;
	}
	
	private String formatNum(Object val){
		String valStr = EStr.isEmpty(val) ? "" : val.toString();
		return valStr.replaceAll("\\.0$", "");
	}

}