package itez.plat.main.service.impl;

import itez.core.runtime.service.EModelService;
import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.kit.EStr;
import itez.kit.restful.EMap;
import itez.core.runtime.service.Define;
import itez.plat.main.model.Counter;
import itez.plat.main.service.CounterService;

import com.google.inject.Singleton;
import com.jfinal.plugin.activerecord.Record;
import com.jfinal.plugin.activerecord.SqlPara;

/**
 * 由JWinner Service Generator自动生成。
 */
@Define
@Singleton
public class CounterServiceImpl extends EModelService<Counter> implements CounterService {

	private Counter getCounter(String moduleCode, String key){
		if(EStr.isEmpty(moduleCode)) moduleCode = itez.plat.site.ModuleConfig.MODULE_CODE;
		Querys qs = Querys.and(Query.eq("moduleCode", moduleCode)).add(Query.eq("key", key));
		return selectFirst(qs);
	}
	
	private synchronized Counter createCounter(String moduleCode, String key){
		Counter cnt = getCounter(moduleCode, key);
		if(cnt != null) return cnt;
		cnt = new Counter().setModuleCode(moduleCode).setKey(key).setCnt(0l);
		save(cnt);
		return cnt;
	}
	
	@Override
	public Integer access(String moduleCode, String key) {
		Counter cnt = getCounter(moduleCode, key);
		if(cnt == null) cnt = createCounter(moduleCode, key);
		long c = cnt.getCnt() + 1;
		cnt.setCnt(c);
		update(cnt);
		return (int)c;
	}

	@Override
	public Integer count(String moduleCode, String key) {
		if(EStr.isEmpty(moduleCode)) moduleCode = itez.plat.site.ModuleConfig.MODULE_CODE;
		EMap map = EMap.by("domain", $domain()).set("moduleCode", moduleCode).set("key", key);
		SqlPara sql = dbo().getSqlPara("main.getCountor", map);
		Record rec = dbo().findFirst(sql);
		if(rec == null) return 0;
		return rec.getInt("cnt");
	}

}