package itez.plat.main.service.impl;

import itez.core.runtime.service.EModelService;
import itez.core.util.ECacheKit;
import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.kit.EStr;
import itez.plat.main.model.Config;
import itez.plat.main.model.ConfigDefault;
import itez.plat.main.service.ConfigDefaultService;
import itez.plat.main.service.ConfigService;
import itez.core.runtime.cache.Cache;
import itez.core.runtime.service.Define;

import java.util.List;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.jfinal.kit.Kv;
import com.jfinal.plugin.activerecord.Record;
import com.jfinal.plugin.activerecord.SqlPara;

/**
 * 由JWinner Service Generator自动生成。
 */
@Define
@Singleton
public class ConfigServiceImpl extends EModelService<Config> implements ConfigService {

	@Inject
	ConfigDefaultService configDefService;

	@Override
	public ConfigDefault getByDomainCode(String domain, String code) {
		if(EStr.isEmpty(domain)) domain = $domain();
		ConfigDefault def = configDefService.getByCode(code);
		if(def == null) throw new RuntimeException("参数不存在：" + code);
		Config cfg = getSelfByCode(domain, code);
		if(cfg == null){
			return def;
		}else{
			return def.setValue(cfg.getValue());
		}
	}
	
	@Override
	public void setByDomainCode(String domain, String code, String value) {
		if(EStr.isEmpty(domain)) domain = $domain();
		Config cfg = getSelfByCode(domain, code);
		if(cfg == null){
			new Config().setDomain(domain).setCode(code).setValue(value).save();
		}else{
			cfg.setValue(value).update();
		}
		ECacheKit.removeBase(ECacheKit.appendTenant(domain, "Config"), code);
	}
	
	private Config getSelfByCode(String domain, String code){
		if(EStr.isEmpty(domain)) domain = $domain();
		Querys qs = Querys.and(Query.eq("domain", domain)).add(Query.eq("code", code));
		return selectFirst(qs, null, false);
	}

	@Override
	@Cache.able(cache="Config", key="code")
	public ConfigDefault getByCode(String code){
		return getByDomainCode(null, code);
	}

	@Override
	public void setByCode(String code, String value) {
		setByDomainCode(null, code, value);
	}

	@Override
	public String getValue(String code){
		ConfigDefault def = getByCode(code);
		return def.getValue();
	}

	@Override
	public Boolean getBool(String code){
		ConfigDefault def = getByCode(code);
		String type = def.getType().toLowerCase();
		String value = def.getValue();
		if(type.equals("boolean")){
			return value.equals("1") || value.equals("true");
		}else{
			return false;
		}
	}

	@Override
	public Integer getInt(String code) {
		ConfigDefault def = getByCode(code);
		String type = def.getType().toLowerCase();
		String value = def.getValue();
		if(type.equals("int")){
			return EStr.isNull(value) ? 0 : Integer.parseInt(value);
		}else{
			return 0;
		}
	}

	@Override
	@SuppressWarnings("unchecked")
	public <T> T getBy(String code) {
		String val = getValue(code);
		if(val == null) return null;
		return (T)val;
	}

	@Override
	public List<Record> getByGroup(String groupId) {
		SqlPara sql = dbo().getSqlPara("main.getConfigList", Kv.by("domain", $domain()).set("groupId", groupId));
		return dbo().find(sql);
	}

}