package itez.plat.main.service.impl;

import itez.core.runtime.service.EModelService;
import itez.core.util.ECacheKit;
import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.kit.EStr;
import itez.kit.restful.EMap;
import itez.plat.main.model.ConfigDefault;
import itez.plat.main.service.ConfigDefaultService;
import itez.plat.main.service.ConfigService;
import itez.core.runtime.cache.Cache;
import itez.core.runtime.service.Define;

import java.util.List;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.jfinal.plugin.activerecord.Record;
import com.jfinal.plugin.activerecord.SqlPara;

/**
 * 由JWinner Service Generator自动生成。
 */
@Define
@Singleton
public class ConfigDefaultServiceImpl extends EModelService<ConfigDefault> implements ConfigDefaultService {

	@Inject
	ConfigService cfgSer;
	
	@Cache.able(cache="ConfigDefault", key="code")
	public ConfigDefault getByCode(String code){
		Querys qs = Querys.and(Query.eq("code", code));
		return selectFirst(qs);
	}

	@Override
	public List<ConfigDefault> getByGroup(String groupId) {
		Querys qs = Querys.and(Query.eq("groupId", groupId));
		return select(qs);
	}
	
	@Override
	public boolean saveOrUpdate(ConfigDefault model) {
		ECacheKit.removeGlobal("ConfigDefault", model.getCode());
		ECacheKit.removeGlobal("Config", model.getCode());
		return super.saveOrUpdate(model);
	}

	@Override
	public List<Record> getCompsVal(String code) {
		SqlPara sql = dbo().getSqlPara("main.getCompsVal", EMap.by("code", code));
		return dbo().find(sql);
	}

	@Override
	public void cleanCompsVal(String code, String domains) {
		SqlPara sql = dbo().getSqlPara("main.cleanCompsVal", EMap.by("code", code).set("domains", EStr.ids2sqlIn(domains)));
		dbo().update(sql);
		String[] domainArr = domains.split(",");
		for(String dom : domainArr){
			ECacheKit.removeBase(ECacheKit.appendTenant(dom, "Config"), code);
		}
	}
	
	@Override
	public void setCompsVal(String code, String domains, String value) {
		String[] domainArr = domains.split(",");
		for(String dom : domainArr){
			cfgSer.setByDomainCode(dom, code, value);
		}
	}

}