package itez.plat.main.service.impl;

import itez.core.runtime.service.EModelService;
import itez.core.runtime.service.common.ICompService;
import itez.core.util.ECacheKit;
import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.plat.main.model.Comp;
import itez.plat.main.service.CompService;
import itez.core.runtime.cache.Cache;
import itez.core.runtime.service.Define;

import java.util.List;

import com.google.inject.Singleton;

/**
 * 由JWinner Service Generator自动生成。
 */
@Define
@Singleton
public class CompServiceImpl extends EModelService<Comp> implements CompService, ICompService {

	@Override
	@Cache.able(cache="COMP_BY_ID", key="id")
	public Comp findById(String id) {
		return super.findById(id);
	}

	@Override
	@Cache.able(cache="COMP_BY_DOMAIN", key="domain")
	public Comp findByDomain(String domain) {
		Querys qs = Querys.and(Query.eq("domain", domain));
		return selectFirst(qs);
	}

	@Override
	public boolean update(Comp comp){
		removeCompCache(comp);
		return super.update(comp);
	}
	
	@Override
	public boolean saveOrUpdate(Comp comp) {
		removeCompCache(comp);
		return super.saveOrUpdate(comp);
	}
	
	@Override
	public boolean disable(String id) {
		Comp comp = findById(id);
		removeCompCache(comp);
		return super.disable(comp);
	}

	@Override
	public List<Comp> getAllComp() {
		Querys qs = Querys.and(Query.eq("used", 1));
		return select(qs, null, null, false);
	}

	@Override
	public Comp getByDomain(String domain) {
		Querys qs = Querys.and(Query.eq("domain", domain)).add(Query.eq("used", 1));
		return selectFirst(qs, null, false);
	}
	
	/**
	 * <p>
	 * 清空租户缓存
	 * 由于在DomainHandle中引用了findByDomain方法，但当时还未初始化ATTR会话，因此添加到缓存中的COMP未附加子域前缀，需要特别处理
	 * </p>
	 * 
	 * @param comp
	 */
	private void removeCompCache(Comp comp){
		ECacheKit.remove("COMP_BY_ID", comp.getId());
		ECacheKit.remove("COMP_BY_DOMAIN", comp.getDomain());
		ECacheKit.removeBase("COMP_BY_ID", comp.getId());
		ECacheKit.removeBase("COMP_BY_DOMAIN", comp.getDomain());
		ECacheKit.removeBase(ECacheKit.appendTenant(comp.getDomain(), "COMP_BY_ID"), comp.getId());
		ECacheKit.removeBase(ECacheKit.appendTenant(comp.getDomain(), "COMP_BY_DOMAIN"), comp.getDomain());
	}

}