package itez.plat.main.service;

import java.util.List;

import itez.core.runtime.service.IModelService;
import itez.plat.main.model.UserOauth;
import itez.tp.ApiCommon.USR_SOURCE;

/**
 * 第三方账号集成管理
 * 
 * @author netwild
 *
 */
public interface UserOauthService extends IModelService<UserOauth>{

	/**
	 * <p>
	 * 返回绑定的统一身份信息
	 * 跨域，主要用于第三方账号登录或绑定时判断该第三方账号是否已经绑定内置账号，如：站群管理员单点登录功能
	 * </p>
	 * 
	 * @param type 第三方平台类型
	 * @param origId 用户在第三方平台中的原始ID
	 * @return 本地用户ID
	 */
	String getBindUid(USR_SOURCE type, String origId);
	
	/**
	 * <p>
	 * 根据源用户ID返回统一身份信息
	 * </p>
	 * 
	 * @param type 第三方平台类型
	 * @param origId 用户在第三方平台中的原始ID
	 * @return 绑定信息
	 */
	UserOauth getByOrigId(USR_SOURCE type, String origId);
	
	/**
	 * <p>
	 * 根据源用户代码返回统一身份信息
	 * </p>
	 * 
	 * @param type 第三方平台类型
	 * @param origCode 用户在第三方平台中的原始代码
	 * @return 绑定信息
	 */
	UserOauth getByOrigCode(USR_SOURCE type, String origCode);
	
	/**
	 * <p>
	 * 根据openid返回统一身份信息
	 * </p>
	 * 
	 * @param type 第三方平台类型
	 * @param openid 用户在第三方平台中的openId
	 * @return 绑定信息
	 */
	UserOauth getByOpenid(USR_SOURCE type, String openid);
	
	/**
	 * <p>
	 * 根据unionid返回统一身份信息
	 * </p>
	 * 
	 * @param type 第三方平台类型
	 * @param unionid 用户在第三方平台中的unionid
	 * @return 绑定信息
	 */
	UserOauth getByUnionid(USR_SOURCE type, String unionid);
	
	/**
	 * <p>
	 * 返回指定用户ID的指定绑定信息
	 * </p>
	 * 
	 * @param type 第三方平台类型
	 * @param userId 本地用户ID
	 * @return 绑定信息
	 */
	UserOauth getByUserId(USR_SOURCE type, String userId);
	
	/**
	 * <p>
	 * 返回指定用户ID的所有已绑定的认证信息
	 * </p>
	 * 
	 * @param userId 本地用户ID
	 * @return 绑定列表
	 */
	List<UserOauth> getByUserId(String userId);

}