package itez.plat.main.service;

import itez.core.runtime.service.IService;
import itez.kit.restful.Result;
import itez.plat.main.model.User;
import itez.plat.main.model.UserLockedInfo;

/**
 * 安全登录相关逻辑管理
 * 
 * @author netwild
 *
 */
public interface UserLoginService extends IService {
	
	/**
	 * 清理User中的非法脚本
	 */
	void cleanUserXss(User user);
	
	/**
	 * 使用密码登录校验
	 * @param user 可通过以下属性作为登录名：loginName、idNum、phone、email
	 * @param loginPass 密码
	 * @param policyAccCode 账号方案代码
	 * @return 通过校验的用户对象，未通过时将抛出运行时异常
	 */
	User pwdLogin(User user, String loginPass, String policyAccCode);
	
	/**
	 * 返回当前输入条件的锁定信息
	 * @param user
	 * @return
	 */
	UserLockedInfo getLockInfo(User user);
		
	/**
	 * 移除锁定清单
	 * @param uid
	 */
	void removeLockList(String uid);
	
	/**
	 * 强密码校验
	 * @param loginPass 密码串
	 * @param policyPwdCode 密码策略代码，为空时将使用默认策略
	 * @return 校验结果
	 */
	Result pwdVali(String loginPass, String policyPwdCode);
	
	/**
	 * 生成指定用户的单点登录入口地址，每次调用都会生成一个新的Token，有效期30分钟
	 * 
	 * @param userId 用户ID，该ID应从用户集成表（oauth）中通过已绑定的第三方账号获取
	 * @return 返回一个可用于单点登录的URL，包含临时生成的TOKEN
	 */
	String ssoRouter(String userId);
	
	/**
	 * 使用Token单点登录
	 * 
	 * @param token 含有用户ID和时间戳的加密字符串
	 * @return 返回校验通过的用户对象
	 */
	User ssoLogin(String token);
	
	/**
	 * 加密TOKEN串
	 * @param data 待生成TOKEN的数据
	 * @return
	 */
	String tokenEncode(String data);
	
	/**
	 * 加密TOKEN串
	 * @param data 待生成TOKEN的数据
	 * @param key 密钥
	 * @return
	 */
	String tokenEncode(String data, String key);
	
	/**
	 * 解密TOKEN串
	 * @param code 待解密的TOKEN数据
	 * @return
	 */
	String tokenDecode(String code);
	
	/**
	 * 解密TOKEN串
	 * @param code 待解密的TOKEN数据
	 * @param key 密钥
	 * @return
	 */
	String tokenDecode(String code, String key);
	
}
