package itez.plat.main.service;

import java.io.File;
import java.util.List;
import java.util.Map;

import itez.core.runtime.service.IModelService;
import itez.core.wrapper.dbo.model.Querys;
import itez.kit.restful.EMap;
import itez.kit.restful.Result;
import itez.plat.main.model.Terminal;

/**
 * 由JWinner Service Generator自动生成。
 */
public interface TerminalService extends IModelService<Terminal>{

	/**
	 * <p>
	 * 获得终端对象
	 * </p>
	 * 
	 * @return
	 */
	Terminal getTer();
	
	/**
	 * <p>
	 * 获得终端对象
	 * </p>
	 * 
	 * @param id
	 * @return
	 */
	Terminal getByDomain(String domain);
	
	/**
	 * <p>
	 * 获得终端对象
	 * </p>
	 * 
	 * @param qs
	 * @return
	 */
	List<Terminal> getTers(Querys qs);
	
	/**
	 * <p>
	 * 获得可用的终端对象
	 * </p>
	 * 
	 * @return
	 */
	List<Terminal> getActiveTer();
	
	/**
	 * <p>
	 * 获得全部终端对象
	 * </p>
	 * 
	 * @return
	 */
	List<Terminal> getAllTer();
	
	/**
	 * <p>
	 * 获得全部终端对象的JSON
	 * </p>
	 * 
	 * @return
	 */
	String getAllTerJson();
	
	/**
	 * <p>
	 * 保存终端对象
	 * </p>
	 * 
	 * @param ter
	 * @return
	 */
	Terminal saveTer(Terminal ter);
	
	/**
	 * <p>
	 * 向终端发送文件
	 * </p>
	 * 
	 * @param term 终端对象
	 * @param url 资源地址，不含域名
	 * @param files 文件集合
	 * @param params 含有签名（sign）的参数集合
	 * @return
	 */
	String pushFile2Str(Terminal term, String url, Map<String, File> files, EMap params);
	
	/**
	 * <p>
	 * 向终端发送文件
	 * </p>
	 * 
	 * @param domain 终端子域
	 * @param url 资源地址，不含域名
	 * @param files 文件集合
	 * @param params 含有签名（sign）的参数集合
	 * @return
	 */
	String pushFile2Str(String domain, String url, Map<String, File> files, EMap params);
	
	/**
	 * <p>
	 * 向终端发送文件
	 * </p>
	 * 
	 * @param term 终端对象
	 * @param url 资源地址，不含域名
	 * @param files 文件集合
	 * @param params 含有签名（sign）的参数集合
	 * @return
	 */
	Result pushFile(Terminal term, String url, Map<String, File> files, EMap params);
	
	/**
	 * <p>
	 * 向终端发送文件
	 * </p>
	 * 
	 * @param domain 终端子域
	 * @param url 资源地址，不含域名
	 * @param files 文件集合
	 * @param params 含有签名（sign）的参数集合
	 * @return
	 */
	Result pushFile(String domain, String url, Map<String, File> files, EMap params);
	
	/**
	 * <p>
	 * 向终端发送请求
	 * </p>
	 * 
	 * @param term 终端对象
	 * @param url 资源地址，不含域名
	 * @param params 含有签名（sign）的参数集合
	 * @return
	 */
	String pushData2Str(Terminal term, String url, EMap params);
	
	/**
	 * <p>
	 * 向终端发送请求
	 * </p>
	 * 
	 * @param domain 终端子域
	 * @param url 资源地址，不含域名
	 * @param params 含有签名（sign）的参数集合
	 * @return
	 */
	String pushData2Str(String domain, String url, EMap params);
	
	/**
	 * <p>
	 * 向终端发送请求
	 * </p>
	 * 
	 * @param term 终端对象
	 * @param url 资源地址，不含域名
	 * @param params 含有签名（sign）的参数集合
	 * @return
	 */
	Result pushData(Terminal term, String url, EMap params);
	
	/**
	 * <p>
	 * 向终端发送请求
	 * </p>
	 * 
	 * @param domain 终端子域
	 * @param url 资源地址，不含域名
	 * @param params 含有签名（sign）的参数集合
	 * @return
	 */
	Result pushData(String domain, String url, EMap params);
	
	/**
	 * <p>
	 * 生成签名
	 * 注意：如果某参数同时进行加密与签名，需要先进行 [签名] 再进行 [加密]。
	 * </p>
	 * 
	 * @param term 终端对象
	 * @param params 原始请求参数集合
	 * @param keys 参与签名的字段列表，注意顺序
	 * @return
	 */
	EMap genSign(Terminal term, EMap params, String[] keys);
	
	/**
	 * <p>
	 * 对请求参数进行加密处理
	 * 注意：如果某参数同时进行加密与签名，需要先进行 [签名] 再进行 [加密]。
	 * </p>
	 * 
	 * @param term 终端对象
	 * @param params
	 * @param keys
	 * @return
	 */
	EMap encrypt(Terminal term, EMap params, String[] keys);
	
	/**
	 * <p>
	 * 对请求参数进行解密处理
	 * 注意：如果请求方同时对某参数进行了加密与签名，则校验时应先 [解密] 再进行 [签名校验]
	 * </p>
	 * 
	 * @param term 终端对象
	 * @param params
	 * @param keys
	 * @return
	 */
	EMap decrypt(Terminal term, EMap params, String[] keys);
	
	/**
	 * <p>
	 * 签名校验
	 * 注意：如果请求方同时对某参数进行了加密与签名，则校验时应先 [解密] 再进行 [签名校验]
	 * </p>
	 * 
	 * @param term 终端对象
	 * @param params 含有签名（sign）的参数集合
	 * @param keys 参与签名的字段列表，注意顺序
	 * @return
	 */
	boolean valiSign(Terminal term, EMap params, String[] keys);

}