package itez.plat.main.service;

import java.io.File;
import java.util.List;

import com.jfinal.plugin.activerecord.Record;

import itez.core.runtime.service.IModelService;
import itez.plat.main.model.Role;

/**
 * 由JWinner Service Generator自动生成。
 */
public interface RoleService extends IModelService<Role>{

	List<Role> getByModule(String moduleCode);
	
	/**
	 * 返回全部角色，超级管理员默认拥有全部角色
	 * @return
	 */
	List<Role> getAll();
	
	/**
	 * <p>
	 * 返回当前租户授权模块内的所有角色
	 * </p>
	 * 
	 * @return
	 */
	List<Role> getByComp();
	
	/**
	 * <p>
	 * 返回当前租户授权模块内，指定代码的角色列表
	 * </p>
	 * 
	 * @return
	 */
	List<Role> getByCodeInComp(String codes);
	
	/**
	 * <p>
	 * 返回当前用户授权模块内，指定代码的角色列表
	 * </p>
	 * 
	 * @return
	 */
	List<Record> getByCodeInModule(String moduleIds, String codes);
	
	/**
	 * Excel导入
	 * @param moduleCode
	 * @param file
	 * @param repeatCode
	 * @return
	 */
	int imports(String moduleCode, File file, boolean repeatCode);
	
	/**
	 * 在指定子域内，根据代码查找
	 * @param domain
	 * @param code
	 */
	Role findInCompByCode(String domain, String code);
	
	/**
	 * 初始化
	 * @param domain
	 * @param moduleCode
	 * @param json
	 * @return
	 */
	void importJson(String domain, String moduleCode);
	
	/**
	 * JSON导入
	 * @param domain
	 * @param moduleCode
	 * @param json
	 * @return
	 */
	void importJson(String domain, String moduleCode, String json);

}