package itez.plat.main.service;

import java.util.List;

import com.jfinal.plugin.activerecord.Record;

import itez.core.runtime.service.IService;
import itez.kit.EPara;
import itez.kit.restful.EMap;
import itez.plat.main.service.impl.PolicyServiceImpl.POLICYS;

/**
 * 安全策略业务逻辑
 * @author netwild
 *
 */
public interface PolicyService extends IService {
	
	/**
	 * 返回全部策略列表
	 * @return
	 */
	List<EMap> getPolicyList();
	
	/**
	 * 返回指定策略的明细列表
	 * @param type
	 * @return
	 */
	List<Record> getDetails(POLICYS type);
	
	/**
	 * 新增或修改指定策略
	 * @param type
	 * @param paras
	 */
	void modify(POLICYS type, EPara paras);
	
	/**
	 * 删除指定策略
	 * @param type
	 * @param paras
	 */
	void remove(POLICYS type, String code);

}
