package itez.plat.main.service;

import java.util.List;

import com.jfinal.plugin.activerecord.Record;

import itez.core.runtime.service.IModelService;
import itez.plat.main.model.PolicyAccount;

/**
 * 由JWinner Service Generator自动生成。
 */
public interface PolicyAccountService extends IModelService<PolicyAccount>{

	/**
	 * 获取账号模型方案列表（包括默认方案，主要用于后台管理）
	 * @param moduleCode
	 * @return
	 */
	List<Record> getDefPolicys(String moduleCode);
	
	/**
	 * 添加或修改方案
	 * @param acc
	 * @return
	 */
	PolicyAccount modify(PolicyAccount acc);
	
	/**
	 * 删除方案
	 * @param acc
	 * @return
	 */
	void removes(String ids);
	
	/**
	 * 删除预置方案
	 * @param code
	 */
	void removeDefPolicy(String code);
	
	/**
	 * 导入方案
	 * @param json
	 */
	void exportIn(String json);
	
	/**
	 * 获取指定方案
	 * @param code
	 * @return
	 */
	PolicyAccount getPolicy(String code);
	
	/**
	 * 获取指定的预置方案
	 * @param code
	 * @return
	 */
	PolicyAccount getPolicyDef(String code);
	
	/**
	 * 返回全局方案设置
	 * @param code
	 * @return
	 */
	List<Record> getGlobals(String code);
	
	/**
	 * 清除指定租户的自定义方案
	 * @param code
	 * @param doms
	 */
	void cleanGlobals(String code, String doms);

}