package itez.plat.main.service;

import java.io.File;
import java.util.List;

import itez.core.runtime.service.IModelService;
import itez.plat.main.model.Perm;

/**
 * 由JWinner Service Generator自动生成。
 */
public interface PermService extends IModelService<Perm>{

	/**
	 * 返回指定模块的所有权限
	 * @param moduleCode
	 * @return
	 */
	List<Perm> getByModule(String moduleCode);
	
	/**
	 * 返回租户的全部权限
	 * @return
	 */
	List<Perm> getByComp();
	
	/**
	 * Excel导入
	 * @param moduleCode
	 * @param file
	 * @param repeatCode
	 * @return
	 */
	int imports(String moduleCode, File file, boolean repeatCode);
	
	/**
	 * 在指定子域内，根据代码查找
	 * @param domain
	 * @param code
	 */
	Perm findInCompByCode(String domain, String code);
	
	/**
	 * 初始化
	 * @param domain
	 * @param moduleCode
	 * @return
	 */
	void importJson(String domain, String moduleCode);
	
	/**
	 * JSON导入
	 * @param domain
	 * @param moduleCode
	 * @param json
	 * @return
	 */
	void importJson(String domain, String moduleCode, String json);

}