package itez.plat.main.service;

import java.util.List;

import com.jfinal.aop.Invocation;

import itez.core.runtime.service.ITreeService;
import itez.plat.main.model.Menu;

/**
 * 由JWinner Service Generator自动生成。
 */
public interface MenuService extends ITreeService<Menu>{

	/**
	 * 一次性返回平铺型菜单数据（用于后台菜单管理）
	 * @param mtype
	 * @return
	 */
	public List<Menu> getMenuTree(String mtype);

	/**
	 * 一次性返回平铺型菜单数据（用于后台菜单管理，是否存在某模块的菜单数据，如果没有，则进行初始化）
	 * @param mtype
	 * @return
	 */
	public List<Menu> getMenuTree(String mtype, String module);

	/**
	 * 一次性返回平铺型菜单数据（用于后台菜单管理，是否存在某模块的菜单数据，如果没有，则进行初始化）
	 * @param mtype
	 * @return
	 */
	public List<Menu> getMenuTree(String mtype, String module, String domain);
	
	/**
	 * 一次性返回树型菜单数据（用于前台菜单展示）
	 * @param mtype
	 * @return
	 */
	public List<Menu> getCompMenus(String mtype);
	
	/**
	 * <p>
	 * 返回指定分类的子菜单
	 * </p>
	 * 
	 * @param mtype
	 * @param pid
	 * @return
	 */
	public List<Menu> getCompMenus(String mtype, String pid);
	
	/**
	 * <p>
	 * 返回指定分类、指定模块的子菜单
	 * </p>
	 * 
	 * @param mtype
	 * @param pid
	 * @return
	 */
	public List<Menu> getCompMenus(String mtype, String pid, String moduleCode);
	
	/**
	 * 一次性返回树型菜单数据（指定父菜单，用于前台菜单展示）
	 * @param mtype
	 * @param pid
	 * @return
	 */
	public List<Menu> getCompMenus(String mtype, String pid, boolean minMode);
	
	/**
	 * 一次性返回树型菜单数据（指定父菜单、指定模块，用于前台菜单展示）
	 * @param mtype
	 * @param pid
	 * @return
	 */
	public List<Menu> getCompMenus(String mtype, String pid, String moduleCode, boolean minMode);
	
	/**
	 * <p>
	 * 获取指定分类的最后一个菜单项
	 * </p>
	 * 
	 * @param mtype
	 * @param pid
	 * @return
	 */
	public Menu getLastMenu(String mtype, String pid);
	
	/**
	 * <p>
	 * 获取指定分类的最后一个菜单项
	 * </p>
	 * 
	 * @param mtype
	 * @param pid
	 * @return
	 */
	public Menu getLastMenu(String domain, String mtype, String pid);
	
	/**
	 * <p>
	 * 菜单排序
	 * </p>
	 * 
	 * @param mtype
	 * @param pid
	 * @param dir
	 * @param ids
	 */
	public void sort(String mtype, String pid, String dir, String ids);
	
	/**
	 * <p>
	 * 初始化指定模块的菜单
	 * </p>
	 * 
	 * @param mtype
	 * @param moduleCode
	 */
	public void init(String domain, String mtype, String moduleCode);
	
	/**
	 * 菜单鉴权
	 * @param inv
	 * @param mtype
	 */
	public Boolean interceptorMenu(Invocation inv, String mtype);
	
	/**
	 * 菜单缓存重置
	 */
	public void sessMenuClear();
	
	/**
	 * <p>
	 * 删除指定目录以及所有子菜单
	 * </p>
	 * 
	 * @param mtype
	 * @param path
	 */
	public void delMenuByPath(String mtype, String path);
	
	/**
	 * <p>
	 * 删除指定模块的所有菜单
	 * </p>
	 * 
	 * @param mtype
	 * @param moduleCode
	 */
	public void delMenuByModule(String domain, String mtype, String moduleCode);

}