package itez.plat.main.service;

import java.io.File;
import java.util.List;

import itez.core.runtime.service.ITreeService;
import itez.kit.EPara;
import itez.plat.main.model.Dept;

/**
 * 机构相关逻辑管理
 * 
 * @author netwild
 *
 */
public interface DeptService extends ITreeService<Dept>{

	/**
	 * <p>
	 * 创建当前租户的根机构（部门）
	 * </p>
	 * 
	 * @return 根机构
	 */
	public Dept createRootDept();
	
	/**
	 * <p>
	 * 返回当前租户的根机构（部门）
	 * </p>
	 * 
	 * @return 根机构
	 */
	public Dept getRootDept();
	
	
	
	//////////////////////////////////////////////// 返回树型模式的机构列表  /////////////////////////////////////////////
	
	
	
	/**
	 * <p>
	 * 返回当前租户的全部机构树形（默认解析逻辑机构）
	 * </p>
	 * 
	 * @return 机构列表
	 */
	public List<Dept> getDeptTree();
	
	/**
	 * <p>
	 * 返回从指定机构开始的机构树形（默认解析逻辑机构）
	 * </p>
	 * 
	 * @param rootId 根机构ID
	 * @return 机构列表
	 */
	public List<Dept> getDeptTree(String rootId);
	
	/**
	 * <p>
	 * 返回从指定机构开始的机构树形，指定是否解析逻辑机构
	 * </p>
	 * 
	 * @param rootId 根机构ID
	 * @param includeLogic 是否解析逻辑机构
	 * @return 机构列表
	 */
	public List<Dept> getDeptTree(String rootId, boolean includeLogic);
	
	
	
	//////////////////////////////////////////////// 返回扁平模式（非树型）的机构列表  /////////////////////////////////////////////
	
	
	
	/**
	 * <p>
	 * 返回第一层子机构列表
	 * </p>
	 * 
	 * @return 机构列表
	 */
	public List<Dept> getSubDepts();
	
	/**
	 * <p>
	 * 返回指定机构的子机构列表，仅包括一层的直接子机构
	 * </p>
	 * 
	 * @param pid 机构ID
	 * @return 子机构列表
	 */
	public List<Dept> getSubDepts(String pid);
	
	/**
	 * <p>
	 * 返回指定机构的子机构列表，仅包括一层的直接子机构
	 * </p>
	 * 
	 * @param pid 机构ID
	 * @param typeCode 机构类型（支持逗号分割的多个类型代码）
	 * @return 子机构列表
	 */
	public List<Dept> getSubDepts(String pid, String typeCode);
	
	
	
	
	
	//////////////////////////////////////////////// 查找上级机构   /////////////////////////////////////////////
	
	
	
	
	
	/**
	 * 返回父机构
	 * @param id 当前机构ID
	 * @return 父机构
	 */
	public Dept getParent(String id);
	
	/**
	 * 返回符合typeCode的距离最近的祖先机构（不包括本身）
	 * @param id 当前机构ID
	 * @param typeCode 机构类型（支持逗号分割的多个类型代码）
	 * @return 父机构
	 */
	public Dept getParent(String id, String typeCode);
	
	
	
	
	
	//////////////////////////////////////////////// 查找指定类型的下级机构   /////////////////////////////////////////////

	

	/**
	 * 返回符合typeCode的所有下级机构（不包括本身），自动解析逻辑机构
	 * 注意：通过类型代码过滤后的结果将不再保持树形机构
	 * @param typeCode 机构类型（支持逗号分割的多个类型代码）
	 * @return 下级机构列表
	 */
	public List<Dept> getChildrens(String typeCode);
	
	/**
	 * 返回符合typeCode的所有下级机构（不包括本身），自动解析逻辑机构
	 * 注意：通过类型代码过滤后的结果将不再保持树形机构
	 * @param typeCode 机构类型（支持逗号分割的多个类型代码）
	 * @param rootId 当前机构ID
	 * @return 下级机构列表
	 */
	public List<Dept> getChildrens(String typeCode, String rootId);
	
	
	
	
	//////////////////////////////////////////////// 逻辑机构相关方法  /////////////////////////////////////////////
	
	
	
	/**
	 * 解析并填充逻辑机构
	 * @param depts 原始机构列表
	 * @return 解析逻辑机构之后的列表
	 */
	public List<Dept> fillLogicDept(List<Dept> depts);
	
	/**
	 * 返回所有引用该逻辑机构的节点列表
	 * @param id 逻辑机构ID
	 * @return 应该该逻辑机构的机构列表
	 */
	public List<Dept> getLogicTo(String id);
	
	

	
	//////////////////////////////////////////////// 其他方法  /////////////////////////////////////////////
	
	

	
	
	/**
	 * <p>
	 * 返回指定机构（部门）的最后一个子机构（部门）
	 * </p>
	 * 
	 * @param pid 当前机构ID
	 * @return 最后一个子机构
	 */
	public Dept getLastDept(String pid);
	
	/**
	 * <p>
	 * 添加或修改机构节点
	 * </p>
	 * 
	 * @param data 机构数据
	 */
	public void event(Dept data);
	
	/**
	 * <p>
	 * 批量修改机构节点
	 * </p>
	 * 
	 * @param paras 机构数据
	 */
	public void eventBatch(EPara paras);
	
	/**
	 * <p>
	 * 添加机构（部门）
	 * </p>
	 * 
	 * @param dept 机构数据
	 */
	public void addDept(Dept dept);
	
	/**
	 * <p>
	 * 修改机构（部门）
	 * </p>
	 * 
	 * @param dept 机构数据
	 */
	public void modifyDept(Dept dept);
	
	/**
	 * <p>
	 * 删除机构（部门）
	 * </p>
	 * 
	 * @param ids 用逗号间隔的机构（部门）ID
	 */
	public void removeDepts(String ids);
	
	/**
	 * <p>
	 * 对机构（部门）进行调整顺序
	 * </p>
	 * 
	 * @param pid 要调整顺序的上级机构（部门）ID
	 * @param opt 调整方式：up（向上），down（向下）
	 * @param ids 要调整顺序的机构ID，用逗号间隔
	 */
	public void sort(String pid, String opt, String ids);
	
	/**
	 * <p>
	 * 机构（部门）批量导入
	 * </p>
	 * 
	 * @param pid 上级机构（部门）ID
	 * @param file 导入文件
	 * @return 成功条数
	 */
	public int imports(String pid, File file);

}