package itez.plat.main.model;

import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;

import com.beust.jcommander.internal.Lists;
import com.jfinal.kit.HashKit;

import itez.core.runtime.EContext;
import itez.core.runtime.service.Ioc;
import itez.core.runtime.service.common.IUser;
import itez.core.runtime.service.common.IUserService;
import itez.kit.EStr;
import itez.plat.main.model.base.BaseUser;
import itez.plat.main.service.ModuleService;
import itez.plat.main.service.PostLevelService;
import itez.plat.main.service.PostService;
import itez.plat.main.service.RoleService;
import itez.plat.main.service.UserService;
import itez.plat.main.service.VertService;

/**
 * 由JWinner Model Generator自动生成。
 */
@SuppressWarnings("serial")
public class User extends BaseUser<User> implements IUser {

	private transient final static IUserService ius = Ioc.getUser();
	private transient final static UserService us = Ioc.get(UserService.class);
	private transient final static PostService ps = Ioc.get(PostService.class);
	private transient final static PostLevelService pls = Ioc.get(PostLevelService.class);
	private transient final static VertService vs = Ioc.get(VertService.class);
	private transient final static RoleService rs = Ioc.get(RoleService.class);
	private transient final static ModuleService ms = Ioc.get(ModuleService.class);

	/**
	 * 实现几个扩展方法，便于通过人员对象获取更多信息
	 */

	
	/**
	 * 返回用户的默认机构（如果是管理员，则返回当前租户的根机构；否则如果存在管辖，则返回管辖机构ID；否则返回本身所在机构ID）
	 * @return 默认机构
	 */
	public Dept getDept(){
		return us.getDept(this);
	}
		
	/**
	 * 返回用户的默认机构ID（如果是管理员，则返回当前租户的根机构；否则如果存在管辖，则返回管辖机构ID；否则返回本身所在机构ID）
	 */
	public String getRootDeptId() {
		return us.getDeptId(this);
	}
	
	/**
	 * 返回用户的默认首页
	 * @return 默认首页地址
	 */
	public String getIndex(){
		String url = EContext.getAttr().getIndexUrl();
		Dept dept = getDept();
		if(dept != null){
			String deptIndex = dept.getIndex();
			if(EStr.notEmpty(deptIndex)) url = EContext.getAttr().getSrc().concat(deptIndex);
		}
		return url;
	}
	
	/**
	 * 返回用户的职位
	 * @return 职位对象
	 */
	public Post getPost(){
		if(super.getPostId() == null) return null;
		Post post = ps.findById(getPostId());
		return post;
	}
	
	/**
	 * 返回用户职级
	 * @return 职级对象
	 */
	public PostLevel getPostLevel(){
		Post post = getPost();
		if(post == null) return null;
		String plevelId = post.getLevelId();
		if(plevelId == null) return null;
		PostLevel plevel = pls.findById(plevelId);
		return plevel;
	}
	
	/**
	 * 返回用户专业
	 * @return 专业对象
	 */
	public Vert getVert(){
		PostLevel plevel = getPostLevel();
		if(plevel == null) return null;
		String vertId = plevel.getVertId();
		if(vertId == null) return null;
		Vert vert = vs.findById(vertId);
		return vert;
	}

	/**
	 * 重写系数：默认取个人系数，为空时取岗位系数
	 */
	@Override
	public BigDecimal getCoef() {
		if(super.getCoef() != null) return super.getCoef();
		Post post = getPost();
		if(post == null) return null;
		return post.getCoef();
	}
	
	/**
	 * 重写角色：默认取个人角色，为空时取岗位角色
	 */
	@Override
	public String getRoleIds() {
		if(checkAdmin()) return rs.getByComp().stream().map(r -> r.getCode()).collect(Collectors.joining(","));
		if(super.getRoleIds() != null) return super.getRoleIds();
		Post post = getPost();
		if(post == null) return null;
		return post.getRoleIds();
	}
	
	/**
	 * 返回当前用户有权访问的模块代码列表
	 */
	@Override
	public String getModuleIds() {
		if(checkAdmin()) return ms.getByComp().stream().map(r -> r.getCode()).collect(Collectors.joining(","));
		if(super.getModuleIds() != null) return super.getModuleIds();
		Post post = getPost();
		if(post == null) return null;
		return post.getModuleIds();
	}
	
	/**
	 * 返回当前用户有权访问的模块列表
	 * @return 模块列表
	 */
	public List<Module> getModules() {
		String moduleIds = getModuleIds();
		return getModules(moduleIds);
	}
	
	/**
	 * 返回指定模块代码的模块列表
	 * @param moduleIds 模块代码，多个代码中间用逗号分割
	 * @return 模块列表
	 */
	public List<Module> getModules(String moduleIds) {
		if(EStr.isEmpty(moduleIds)) return Lists.newArrayList();
		return ms.findByCodes(moduleIds);
	}

	/**
	 * 校验密码
	 */
	@Override
	public boolean checkPass(String password) {
		if(EStr.isEmpty(this.getLoginPass())) return false;
		if(EStr.isEmpty(password)) return false;
		String passCode = HashKit.md5(password.concat(this.getSalt()));
		return this.getLoginPass().equals(passCode);
	}

	/**
	 * 校验管理员权限
	 */
	@Override
	public boolean checkAdmin() {
		Integer level = getLevel();
		if(EStr.isEmpty(level)) return false;
		return level > 0;
	}

	/**
	 * 校验超级管理员权限
	 */
	@Override
	public boolean checkSupAdmin() {
		Integer level = getLevel();
		if(EStr.isEmpty(level)) return false;
		return level > 1;
	}
	
	/**
	 * 在Model中实现鉴权方法
	 * 
	 * 主要为了实现视图模板中的鉴权需求
	 * 
	 * 模板中鉴权方法：
	 * 
	 *   #if(session.user.checkRole("...")) ...
	 */
	
	@Override
	public boolean checkRole(String roleCode) {
		return ius.checkRole(this, roleCode);
	}

	@Override
	public boolean checkRoles(String... roleCodeArr) {
		return ius.checkRoles(this, roleCodeArr);
	}

	@Override
	public boolean checkRolesAny(String... roleCodeArr) {
		return ius.checkRolesAny(this, roleCodeArr);
	}

	@Override
	public boolean checkPerm(String permCode) {
		return ius.checkPerm(this, permCode);
	}

	@Override
	public boolean checkPerms(String... permCodeArr) {
		return ius.checkPerms(this, permCodeArr);
	}

	@Override
	public boolean checkPermsAny(String... permCodeArr) {
		return ius.checkPermsAny(this, permCodeArr);
	}	
	
}
