package itez.plat.main.model;

import itez.core.runtime.EContext;
import itez.kit.EStr;
import itez.plat.main.model.base.BasePolicyAccount;

/**
 * 由JWinner Model Generator自动生成。
 */
@SuppressWarnings("serial")
public class PolicyAccount extends BasePolicyAccount<PolicyAccount> {

	public final static String SESS_KEY_STATE = "_LOGIN";				//SESSION键名后缀：用户登录状态
	public final static String SESS_KEY_UUID = "_UUID";					//SESSION键名后缀：用户id
	
	@Override
	public String getAppUrl() {
		String url = super.getAppUrl();
		if(!url.startsWith("http")){
			String src = EContext.getAttr().getSrc();
			url = src + url;
		}
		return url;
	}
	
	@Override
	public String getSigninUrl() {
		String url = EStr.ifEmpty(super.getSigninUrl(), super.getAppUrl());
		if(!url.startsWith("http")){
			String src = EContext.getAttr().getSrc();
			url = src + url;
		}
		return url;
	}
	
	/***============= 会话操作 ================***/
	
	/**
	 * <p>
	 * 返回Session键名：登录状态
	 * </p>
	 * 
	 * @return
	 */
	public String getSessionStateKey(){
		return getSessPrefix() + SESS_KEY_STATE;
	}
	
	/**
	 * <p>
	 * 返回Session键值：登录状态
	 * </p>
	 * 
	 * @return
	 */
	public boolean getSessionState(){
		Boolean logined = EContext.getSession().getAttr(getSessionStateKey());
		return EStr.notEmpty(logined) && logined;
	}
	
	/**
	 * <p>
	 * 返回Session键名：登录状态
	 * </p>
	 * 
	 * @return
	 */
	public static String getSessionStateKey(String prefix){
		return prefix + SESS_KEY_STATE;
	}
	
	/**
	 * <p>
	 * 返回Session键值：登录状态
	 * </p>
	 * 
	 * @return
	 */
	public static boolean getSessionState(String prefix){
		Boolean logined = EContext.getSession().getAttr(getSessionStateKey(prefix));
		return EStr.notEmpty(logined) && logined;
	}

	/**
	 * <p>
	 * 返回Session键名：登录用户ID
	 * </p>
	 * 
	 * @return
	 */
	public String getSessionUidKey(){
		return getSessPrefix() + SESS_KEY_UUID;
	}

	/**
	 * <p>
	 * 返回Session键值：登录用户ID
	 * </p>
	 * 
	 * @return
	 */
	public String getSessionUid(){
		if(!getSessionState()) return null;
		return EContext.getSession().getAttr(getSessionUidKey());
	}

	/**
	 * <p>
	 * 返回Session键名：登录用户ID
	 * </p>
	 * 
	 * @return
	 */
	public static String getSessionUidKey(String prefix){
		return prefix + SESS_KEY_UUID;
	}

	/**
	 * <p>
	 * 返回Session键值：登录用户ID
	 * </p>
	 * 
	 * @return
	 */
	public static String getSessionUid(String prefix){
		if(!getSessionState(prefix)) return null;
		return EContext.getSession().getAttr(getSessionUidKey(prefix));
	}
	
	/***============= 方案情景 ================***/
	
	/**
	 * <p>
	 * 是否已开启账号密码登录
	 * </p>
	 * 
	 * @return
	 */
	public boolean pwdAble(){
		String modes = getModes();
		return modes.indexOf("pwd") > -1;
	}

	/**
	 * <p>
	 * 是否已开启Email验证码登录
	 * </p>
	 * 
	 * @return
	 */
	public boolean emailAble(){
		String modes = getModes();
		return modes.indexOf("email") > -1;
	}

	/**
	 * <p>
	 * 是否已开启短信验证码登录
	 * </p>
	 * 
	 * @return
	 */
	public boolean phoneAble(){
		String modes = getModes();
		return modes.indexOf("phone") > -1;
	}

	/**
	 * <p>
	 * 是否已开启微信登录
	 * </p>
	 * 
	 * @return
	 */
	public boolean weixinAble(){
		String modes = getModes();
		return modes.indexOf("weixin") > -1;
	}

	/**
	 * <p>
	 * 是否已开启微哨登录
	 * </p>
	 * 
	 * @return
	 */
	public boolean weishaoAble(){
		String modes = getModes();
		return modes.indexOf("weishao") > -1;
	}

	/**
	 * 返回该策略是否要求录入指定基本信息
	 * @return
	 */
	public boolean inputReq(String attrName){
		if(attrName.equals("email") && emailAuth()) return false;
		if(attrName.equals("phone") && phoneAuth()) return false;
		String attrs = getRegAttr();
		return attrs.indexOf(attrName) > -1;
	}

	/**
	 * 返回该策略是否可以使用指定的登录标识
	 * @return
	 */
	public boolean hasIden(String idenName){
		String idens = getPwdIden();
		return idens.indexOf(idenName) > -1;
	}

	/**
	 * 返回该策略是否强制要求进行Email认证
	 * @return
	 */
	public boolean emailAuth(){
		String valis = getValis();
		return valis.indexOf("email") > -1;
	}
	
	/**
	 * 返回该策略是否强制要求进行手机号认证
	 * @return
	 */
	public boolean phoneAuth(){
		String valis = getValis();
		return valis.indexOf("phone") > -1;
	}

	/**
	 * 返回该策略是否允许进行Email认证
	 * @return
	 */
	public boolean emailVali(){
		if(emailAuth()) return true;
		String modes = getModes();
		return modes.indexOf("email") > -1;
	}
	
	/**
	 * 返回该策略是否允许进行手机号认证
	 * @return
	 */
	public boolean phoneVali(){
		if(phoneAuth()) return true;
		String modes = getModes();
		return modes.indexOf("phone") > -1;
	}
	
	/**
	 * 检查指定用户是否已经完成Email认证
	 * @param user
	 * @return
	 */
	public boolean chkEmailAuth(User user){
		return !(emailAuth() && (EStr.isEmpty(user.getEmail()) || !user.getEmailVali()));
	}

	/**
	 * 检查指定用户是否已经完成手机号认证
	 * @param user
	 * @return
	 */
	public boolean chkPhoneAuth(User user){
		return !(phoneAuth() && (EStr.isEmpty(user.getPhone()) || !user.getPhoneVali()));
	}
	
	/**
	 * 检查指定用户是否已经完成全部身份认证
	 * @param user
	 * @return
	 */
	public boolean chkAuth(User user){
		return chkEmailAuth(user) && chkPhoneAuth(user);
	}
	
}
